package cn.com.duiba.tuia.ssp.center.api.remote.media.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;

/**
 * 可投放广告
 * @dateTime 2019-11-07 09:31:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class CanServeAdvertDto implements Serializable {


    /**
     * 序列化 SerialVersionUId
     */
    private static final long serialVersionUID = 1L;

    /**
     * 应用 Id
     */
    private Long appId;

    /**
     * 广告位 Id
     */
    private Long slotId;

    /**
     * 广告 Id
     */
    private Long advertId;

    /**
     * 素材 Id
     */
    private Long materialId;

    /**
     * 落地页 Url
     */
    private String landingPage;

    /**
     * 创意id
     */
    private Long mediaAdvertId;

    /**
     * 更新时间
     */
    private Date gmtModified;

    public CanServeAdvertDto(Long appId, Long slotId, Long advertId, Long materialId, String landingPage, Date gmtModified) {
        this.appId = appId;
        this.slotId = slotId;
        this.advertId = advertId;
        this.materialId = materialId;
        this.landingPage = landingPage;
        this.gmtModified = gmtModified;
    }

    /**
     * 重写 ToString
     * @return 结果
     */
    @Override
    public String toString() {
        StringBuilder builder;
        builder = new StringBuilder(getClass().getSimpleName());
        builder.append(" [ ").append("Hash = ").append(hashCode())
                .append(", advertId=").append(advertId)
                .append(", materialId=").append(materialId)
                .append(", gmtModified=").append(gmtModified)
                .append(", serialVersionUID=").append(serialVersionUID).append(" ]");
        return builder.toString();
    }

}