package cn.com.duiba.tuia.ssp.center.api.remote.media.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * 测试素材 DTO
 * @dateTime 2021-01-18 09:31:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class TestingMaterialDto implements Serializable {


    /**
     * 序列化 SerialVersionUId
     */
    private static final long serialVersionUID = 1L;

    /**
     * 广告主 Id
     */
    private Long advertiserId;

    /**
     * 广告 Id
     */
    private Long advertId;

    /**
     * 素材 Id
     */
    private Long materialId;

    /**
     * 素材 url
     */
    private String materialUrl;

    /**
     * 素材类型
     * -- { 1 : 图片 , 2 : 视频 , 默认 : 1 }
     */
    private Integer materialType;

    /**
     * 落地页 Url
     */
    private String landingPage;

}