/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.constant;

import cn.com.duiba.tuia.ssp.center.api.dto.AppStatisticsDataRsp;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqPageQuery;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotStatisticsDataRsp;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public enum SelectRangeType {
    SELECT_RANGE_TYPE_0(0, 0L, 100000L),
    SELECT_RANGE_TYPE_1(1, 100000L, 500000L),
    SELECT_RANGE_TYPE_2(2, 500000L, 1000000L),
    SELECT_RANGE_TYPE_3(3, 1000000L, null);

    private Integer type;
    private Long startRangeVal;
    private Long endRangeVal;

    private SelectRangeType(Integer type, Long startRangeVal, Long endRangeVal) {
        this.type = type;
        this.startRangeVal = startRangeVal;
        this.endRangeVal = endRangeVal;
    }

    public Long getStartRangeVal() {
        return this.startRangeVal;
    }

    public Long getEndRangeVal() {
        return this.endRangeVal;
    }

    public Integer getType() {
        return this.type;
    }

    public static boolean equalsType(Integer type) {
        return type.equals(type);
    }

    public static List<AppStatisticsDataRsp> appFilter(List<AppStatisticsDataRsp> appList, List<Integer> rangeList) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(appList) && CollectionUtils.isNotEmpty(rangeList) && rangeList.size() != 4) {
            for (Integer temp : rangeList) {
                switch (temp) {
                    case 0: {
                        SelectRangeType.buildAppData(list, appList, SELECT_RANGE_TYPE_0.getStartRangeVal(), SELECT_RANGE_TYPE_0.getEndRangeVal());
                        break;
                    }
                    case 1: {
                        SelectRangeType.buildAppData(list, appList, SELECT_RANGE_TYPE_1.getStartRangeVal(), SELECT_RANGE_TYPE_1.getEndRangeVal());
                        break;
                    }
                    case 2: {
                        SelectRangeType.buildAppData(list, appList, SELECT_RANGE_TYPE_2.getStartRangeVal(), SELECT_RANGE_TYPE_2.getEndRangeVal());
                        break;
                    }
                    case 3: {
                        SelectRangeType.buildAppData(list, appList, SELECT_RANGE_TYPE_3.getStartRangeVal(), SELECT_RANGE_TYPE_3.getEndRangeVal());
                        break;
                    }
                }
            }
        }
        return list;
    }

    public static void buildAppData(List<AppStatisticsDataRsp> resultList, List<AppStatisticsDataRsp> paramList, Long startRange, Long endRange) {
        if (endRange != null) {
            for (AppStatisticsDataRsp appStat : paramList) {
                Long adConsume = appStat.getAdConsume();
                if (adConsume < startRange || adConsume > endRange) continue;
                resultList.add(appStat);
            }
        } else {
            for (AppStatisticsDataRsp appStat : paramList) {
                Long adConsume = appStat.getAdConsume();
                if (adConsume < startRange) continue;
                resultList.add(appStat);
            }
        }
    }

    public static List<SlotStatisticsDataRsp> slotFilter(List<SlotStatisticsDataRsp> slotList, List<Integer> rangeList) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(slotList) && CollectionUtils.isNotEmpty(rangeList) && rangeList.size() != 4) {
            for (Integer temp : rangeList) {
                switch (temp) {
                    case 0: {
                        SelectRangeType.buildSlotData(list, slotList, SELECT_RANGE_TYPE_0.getStartRangeVal(), SELECT_RANGE_TYPE_0.getEndRangeVal());
                        break;
                    }
                    case 1: {
                        SelectRangeType.buildSlotData(list, slotList, SELECT_RANGE_TYPE_1.getStartRangeVal(), SELECT_RANGE_TYPE_1.getEndRangeVal());
                        break;
                    }
                    case 2: {
                        SelectRangeType.buildSlotData(list, slotList, SELECT_RANGE_TYPE_2.getStartRangeVal(), SELECT_RANGE_TYPE_2.getEndRangeVal());
                        break;
                    }
                    case 3: {
                        SelectRangeType.buildSlotData(list, slotList, SELECT_RANGE_TYPE_3.getStartRangeVal(), SELECT_RANGE_TYPE_3.getEndRangeVal());
                        break;
                    }
                }
            }
        }
        return list;
    }

    public static void buildSlotData(List<SlotStatisticsDataRsp> resultList, List<SlotStatisticsDataRsp> paramList, Long startRange, Long endRange) {
        if (endRange != null) {
            for (SlotStatisticsDataRsp slotStat : paramList) {
                Long adConsume = slotStat.getAdConsume();
                if (adConsume < startRange || adConsume >= endRange) continue;
                resultList.add(slotStat);
            }
        } else {
            for (SlotStatisticsDataRsp slotStat : paramList) {
                Long adConsume = slotStat.getAdConsume();
                if (adConsume < startRange) continue;
                resultList.add(slotStat);
            }
        }
    }

    public static List<SlotStatisticsDataRsp> slotListPage(List<SlotStatisticsDataRsp> filterList, ReqPageQuery pageDto) {
        if (CollectionUtils.isEmpty(filterList)) {
            return null;
        }
        int size = filterList.size();
        int fromIndex = pageDto.getPageSize() * (pageDto.getCurrentPage() - 1);
        int toIndex = fromIndex + pageDto.getPageSize();
        if (toIndex >= size) {
            toIndex = size;
        }
        return filterList.subList(fromIndex, toIndex);
    }

    public static List<AppStatisticsDataRsp> appListPage(List<AppStatisticsDataRsp> filterList, ReqPageQuery pageDto) {
        if (CollectionUtils.isEmpty(filterList)) {
            return null;
        }
        int size = filterList.size();
        int fromIndex = pageDto.getPageSize() * (pageDto.getCurrentPage() - 1);
        int toIndex = fromIndex + pageDto.getPageSize();
        if (toIndex >= size) {
            toIndex = size;
        }
        return filterList.subList(fromIndex, toIndex);
    }

    public static void appAdConsumeSort(List<AppStatisticsDataRsp> filterList, String sort) {
        Collections.sort(filterList, (o1, o2) -> {
            if (o1.getAdConsume() == null && o2.getAdConsume() == null) {
                return 0;
            }
            if (o1.getAdConsume() == null) {
                return 1;
            }
            if (o2.getAdConsume() == null) {
                return -1;
            }
            if (sort != null && sort.equals("asc")) {
                return o1.getAdConsume().compareTo(o2.getAdConsume());
            }
            return o2.getAdConsume().compareTo(o1.getAdConsume());
        });
    }

    public static void slotAdConsumeSort(List<SlotStatisticsDataRsp> filterList, String sort) {
        Collections.sort(filterList, (o1, o2) -> {
            if (o1.getAdConsume() == null && o2.getAdConsume() == null) {
                return 0;
            }
            if (o1.getAdConsume() == null) {
                return 1;
            }
            if (o2.getAdConsume() == null) {
                return -1;
            }
            if (sort != null && sort.equals("asc")) {
                return o1.getAdConsume().compareTo(o2.getAdConsume());
            }
            return o2.getAdConsume().compareTo(o1.getAdConsume());
        });
    }
}

