/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public class EntityUtil {
    private EntityUtil() {
    }

    public static <I, E> Map<I, E> listToMap(List<E> list, Function<E, I> keyFunc) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<I, E> map = new HashMap<I, E>();
        for (E e : list) {
            map.put(keyFunc.apply(e), e);
        }
        return map;
    }

    public static <I, E> Map<I, E> listToMap(List<E> list, Function<E, I> keyFunc, Predicate<E> filterFunc) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<I, E> map = new HashMap<I, E>();
        for (E e : list) {
            if (filterFunc.test(e)) continue;
            map.put(keyFunc.apply(e), e);
        }
        return map;
    }

    public static <I, E> List<I> getParam(List<E> list, Function<E, I> t) {
        ArrayList<I> result = new ArrayList<I>();
        if (list == null || list.isEmpty()) {
            return result;
        }
        for (E e : list) {
            I k = t.apply(e);
            if (k == null) continue;
            result.add(k);
        }
        return result;
    }

    public static <I, T, E> Map<I, T> listToMap(List<E> list, Function<E, I> keyFunc, Function<E, T> valFunc) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<I, T> map = new HashMap<I, T>();
        for (E e : list) {
            map.put(keyFunc.apply(e), valFunc.apply(e));
        }
        return map;
    }
}

