/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.tool;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class MathUtils {
    private static int DEF_SCALE = 10;

    public static final MathUtils getInstance() {
        return mathUtilHolder.INSTANCE;
    }

    public static BigDecimal bigDecimal(Object object) {
        BigDecimal result;
        if (object == null) {
            throw new NullPointerException();
        }
        try {
            result = new BigDecimal(String.valueOf(object).replaceAll(",", ""));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Please give me a numeral.Not " + object);
        }
        return result;
    }

    public static Double add(Object num1, Object num2) {
        BigDecimal result = MathUtils.bigDecimal(num1).add(MathUtils.bigDecimal(num2));
        return result.setScale(DEF_SCALE, 4).doubleValue();
    }

    public static Double subtract(Object num1, Object num2) {
        BigDecimal result = MathUtils.bigDecimal(num1).subtract(MathUtils.bigDecimal(num2));
        return result.setScale(DEF_SCALE, 4).doubleValue();
    }

    public static Double multiply(Object num1, Object num2) {
        BigDecimal result = MathUtils.bigDecimal(num1).multiply(MathUtils.bigDecimal(num2));
        return result.setScale(DEF_SCALE, 4).doubleValue();
    }

    public static Double divide(Object num1, Object num2) {
        return MathUtils.divide(num1, num2, DEF_SCALE);
    }

    public static Double divide(Object num1, Object num2, Integer scale) {
        if (scale == null) {
            scale = DEF_SCALE;
        }
        Object object = num2 = num2 == null || Math.abs(new Double(num2.toString())) == 0.0 ? Integer.valueOf(1) : num2;
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal result = MathUtils.bigDecimal(num1).divide(MathUtils.bigDecimal(num2), (int)scale, 4);
        return result.doubleValue();
    }

    public static Double round(Object num, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal result = MathUtils.bigDecimal(num).divide(MathUtils.bigDecimal("1"), scale, 4);
        return result.doubleValue();
    }

    public static BigDecimal getRandom(int start, int end) {
        return new BigDecimal((double)start + Math.random() * (double)end);
    }

    public static String format(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (pattern == null || "".equals(pattern)) {
            pattern = "#";
        }
        DecimalFormat format = new DecimalFormat(pattern);
        return format.format(MathUtils.bigDecimal(obj));
    }

    public static String formatAmount(String str) {
        if (str != null) {
            str = str.replaceAll(",", "").trim();
        }
        return str;
    }

    public static String formatNumber(String str) {
        if (str != null) {
            Double strDouble = Double.parseDouble(str.replaceAll(",", "").trim());
            DecimalFormat dFormat = new DecimalFormat("#,##0.00");
            str = dFormat.format(strDouble);
        }
        return str;
    }

    public static String formatAmountString(String amount) {
        if (amount != null) {
            Double strDouble = Double.parseDouble(amount.replaceAll(",", "").trim());
            NumberFormat nFormat = NumberFormat.getCurrencyInstance();
            amount = nFormat.format(strDouble);
        }
        return amount;
    }

    public static String formatExRate(String exrate) {
        if (exrate != null) {
            Double strDouble = Double.parseDouble(exrate.replaceAll(",", "").trim());
            DecimalFormat dFormat = new DecimalFormat("#,##0.000000");
            exrate = dFormat.format(strDouble);
        }
        return exrate;
    }

    public static enum SCALE {
        SCALE_NUM0(0),
        SCALE_NUM1(1),
        SCALE_NUM2(2),
        SCALE_NUM3(3);

        private Integer num;

        private SCALE(Integer num) {
            this.num = num;
        }

        public Integer getNum() {
            return this.num;
        }
    }

    private static class mathUtilHolder {
        private static final MathUtils INSTANCE = new MathUtils();

        private mathUtilHolder() {
        }
    }
}

