/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.util.concurrent;

import cn.com.duiba.tuia.ssp.center.api.util.concurrent.AbstractResultConsumer;
import cn.com.duiba.tuia.ssp.center.api.util.concurrent.AbstractTaskProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhanceCompletionService<V, S> {
    private static final Logger logger = LoggerFactory.getLogger(EnhanceCompletionService.class);
    private ExecutorCompletionService<V> ecs;
    private AtomicBoolean isAllTaskSubmitted = new AtomicBoolean(false);
    private ReentrantLock lock = new ReentrantLock();
    private Condition consumerCondition = this.lock.newCondition();
    private AtomicInteger dealingTaskCount = new AtomicInteger(0);
    private AbstractResultConsumer<V, S> resultConsumer;

    public EnhanceCompletionService(Executor executor, AbstractResultConsumer<V, S> resultConsumer) {
        if (executor instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)executor).setRejectedExecutionHandler((r, executor1) -> {
                try {
                    executor1.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        this.ecs = new ExecutorCompletionService(executor, new LinkedBlockingDeque());
        this.resultConsumer = resultConsumer;
    }

    public void submit(Callable<V> task) {
        this.ecs.submit(task);
        this.dealingTaskCount.incrementAndGet();
        this.notifyFutureConsumerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized S execute(AbstractTaskProvider taskProvider) {
        CompletionQueueConsumerTask futureConsumerThread = new CompletionQueueConsumerTask(this.resultConsumer);
        futureConsumerThread.start();
        try {
            taskProvider.offerTasks(this);
        }
        catch (Throwable e) {
            logger.error("-EnhanceCompletionService\u6267\u884c\u4efb\u52a1\u5f02\u5e38", e);
        }
        finally {
            this.isAllTaskSubmitted.compareAndSet(false, true);
            this.notifyFutureConsumerThread();
            try {
                futureConsumerThread.join();
            }
            catch (InterruptedException e) {
                logger.warn("-EnhanceCompletionService\u6267\u884c\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
            }
        }
        return this.resultConsumer.getResult();
    }

    private void notifyFutureConsumerThread() {
        this.lock.lock();
        try {
            this.consumerCondition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    class CompletionQueueConsumerTask
    extends Thread {
        private AbstractResultConsumer<V, S> resultHandler;

        CompletionQueueConsumerTask(AbstractResultConsumer<V, S> resultHandler) {
            this.resultHandler = resultHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!EnhanceCompletionService.this.isAllTaskSubmitted.get() || EnhanceCompletionService.this.dealingTaskCount.get() > 0) {
                EnhanceCompletionService.this.lock.lock();
                try {
                    if (!EnhanceCompletionService.this.isAllTaskSubmitted.get() && EnhanceCompletionService.this.dealingTaskCount.get() <= 0) {
                        EnhanceCompletionService.this.consumerCondition.await();
                    }
                }
                catch (InterruptedException e) {
                    logger.warn("CompletionQueueConsumerTask\u589e\u5f3a\u670d\u52a1\u7ed3\u679c\u6d88\u8d39\u7ebf\u7a0b\u5728\u6d88\u8d39\u7b49\u5f85\u65f6\u53d1\u751fInterruptedException", (Throwable)e);
                }
                finally {
                    EnhanceCompletionService.this.lock.unlock();
                }
                int count = EnhanceCompletionService.this.dealingTaskCount.get();
                for (int i = 0; i < count; ++i) {
                    try {
                        Object v = EnhanceCompletionService.this.ecs.take().get();
                        this.resultHandler.consume(v);
                        continue;
                    }
                    catch (Throwable e) {
                        logger.error(e.getMessage(), e);
                        continue;
                    }
                    finally {
                        EnhanceCompletionService.this.dealingTaskCount.decrementAndGet();
                    }
                }
            }
        }
    }
}

