package cn.com.duiba.tuia.ssp.center.api.constant.ocpx;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2022/4/11
 * @Description 外部媒体平台枚举
 * @Param
 * @return
 **/
@Getter
public enum ProgrammaticMediaPlatformEnum {
    /**
     * 快手
     */
    KUAISHOU(1, "快手"),
    /**
     * 百度
     */
    BAIDU(2, "百度"),
    /**
     * 巨量
     */
    JULIANG(8, "巨量"),
    /**
     * 广点通
     */
    GUANGDAINTONG(10, "广点通"),
    /**
     * 爱奇艺
     */
    IQIYI(4, "爱奇艺"),
    /**
     * 喜马拉雅
     */
    XIMALAYA(17, "喜马拉雅"),
    /**
     * 趣头条
     */
    QUTOUTIAO(3, "趣头条"),
    /**
     * uc
     */
    UC(16, "UC"),
    /**
     * vivo
     */
    VIVO(15, "VIVO"),

//    /**
//     * 知乎
//     */
//    ZHIHU(5, "知乎"),
//    /**
//     * 微博
//     */
//    WEIBO(6, "微博"),
//    /**
//     * 网易
//     */
//    WANGYI(7, "网易"),

    /**
     * B站
     */
    BLIBLI(9, "B站"),

    /**
     * 360
     */
    API360(19,"360移动"),
    /**
     * wifi万能钥匙
     */
    WN_WIFI(18,"wifi万能钥匙"),
    /**
     *
     */
    SOUL(20,"soul"),

    /**
     * 小米
     */
    XIAOMI(21,"小米"),
    /**
     * 微博
     */
    WEIBO(22,"微博"),
    /**
     * OPPO
     */
    OPPO(23, "OPPO"),
    /**
     * 汇量(原微盟)
     */
    WEIMOB(24, "汇量"),
    /**
     * 搜狐
     */
    SOHU(25, "搜狐"),
    /**
     * 科大讯飞
     */
    IFLYTEK(26, "科大讯飞"),
    /**
     * 华为
     */
    HUA_WEI(27, "华为"),
    /**
     * 网易有道
     */
    YOU_DAO(28,"网易有道"),

    RUAN_GAO(29,"软告"),
    /**
     * 网易易效
     */
    WANGYI_YIXIAO(30,"网易易效"),

    /**
     * 360搜索
     */
    search_360(31,"360搜索"),

    /**
     * 360展示
     */
    DISPLAY_360(32,"360展示"),

    /**
     * Sigmob
     */
    SIGMOB(33,"Sigmob"),

    /**
     * 新浪新闻
     */
    SINA(34,"新浪新闻"),
    /**
     * 多盟
     */
    DOMOB(35,"多盟"),

    /**
     * 优酷
     */
    YOUKU(36,"优酷"),

//    /**
//     * 极光
//     */
//    JIGUANG(11, "极光"),
//    /**
//     * 凤凰新闻
//     */
//    FENGHUANGXINWEN(12, "凤凰新闻"),
//    /**
//     * oppo
//     */
//    OPPO(13, "oppo"),
//    /**
//     * 美团
//     */
//    MEITUAN(14, "美团"),

    BAIDU_ALLIANCE(37,"百度联盟"),
    /**
     * 凤凰网
     */
    FENGHUANG(38,"凤凰网"),
    /**
     * 巨量自建站
     */
    JULINANG_SELF_BUILD_STATION(39,"巨量-自建站"),
    /**
     * 七猫
     */
    QIMAO(40,"七猫"),

    ;

    private Integer platform;

    private String platformName;

    ProgrammaticMediaPlatformEnum(Integer platform, String platformName){
        this.platform = platform;
        this.platformName = platformName;
    }

    public static String getPlatformNameByPlatform(Integer platform){
        for (ProgrammaticMediaPlatformEnum platformEnum : ProgrammaticMediaPlatformEnum.values()){
            if(platformEnum.getPlatform().equals(platform)){
                return platformEnum.getPlatformName();
            }
        }
        return null;
    }

    public static ProgrammaticMediaPlatformEnum getInstanceByCode(Integer code){
        for (ProgrammaticMediaPlatformEnum programmaticMediaPlatformEnum : ProgrammaticMediaPlatformEnum.values()){
            if(programmaticMediaPlatformEnum.getPlatform().equals(code)){
                return programmaticMediaPlatformEnum;
            }
        }
        return null;
    }
}
