package cn.com.duiba.tuia.ssp.center.api.params;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @Author yuquanfeng
 * @Date 2022/4/8
 * @Description
 * @Param
 * @return
 **/
@Data
public class ProgrammaticMediaReportCopyReq extends BaseQueryDto {
    private static final long serialVersionUID = 1L;
    /**
     * 原广告位id
     */
    @NotNull(message = "原广告位ID不能为空")
    private Long originalSlotId;
    /**
     * 目标广告位id
     */
    @NotNull(message = "目标广告位ID不能为空")
    private Long targetSlotId;
    /**
     * 账户id
     */
    private String accountId;
    /**
     * 扩展字段 百度-token
     */
    private String extendValue;

    @NotNull(message = "平台不能为空")
    private Integer mediaPlatform;
    /**
     * 操作人id
     */
    private Long adminId;

    /**
     * vivo srcId
     */
    private String srcId;

    /**
     * 360 key
     */
    private String api360Key;
    /**
     * 360 secret
     */
    private String api360Secret;
    /**
     * 万能wifi钥匙 客户ID
     */
    private String wnClientId;

    /**
     * 万能wifi钥匙 签名密钥
     */
    private String wnSecretkey;

    /**
     * vivo clientId
     */
    private String clientId;
    /**
     * vivo clientSecret
     */
    private String clientSecret;
    /**
     * oppo api_id
     */
    private String apiId;
    /**
     * oppo api_key
     */
    private String apiKey;

    /**
     * sina 转化ID
     */
    private String convId;
    /**
     * sina token
     */
    private String token;
    /**
     * youku appKey
     */
    private String appKey;

    /**
     * 凤凰网转化id
     */
    private String fenghuangConvertId;
    /**
     * 凤凰网加密密钥
     */
    private String fenghuangSecretKey;

}

