package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;

import java.util.List;
import java.util.Map;


@AdvancedFeignClient
public interface RemoteSlotRecommendService {

    /**
     * 查询出广告位id与策略id的全部映射
     * @return
     */
    Map<Long,Long> checkSlotIdFull();

    /**
     * 新增或修改一个广告位维度的推荐位配置
     * @param req
     * @return
     */
    Boolean saveSlotRecommend(SaveSlotRecommendReq req);

    /**
     * 删除一个广告位维度的推荐位配置
     * @param id
     * @return
     */
    Boolean deleteSlotRecommend(Long id);

    /**
     * 查询一个广告位维度的推荐位配置
     * @param id
     * @return
     */
    SlotRecommendInfoDto getSlotRecommend(Long id);

    /**
     * 分页查询广告位维度的推荐位配置
     * @param req
     * @return
     */
    List<SlotRecommendInfoDto> queryList(BaseQueryDto req);

    /**
     * 总条数
     * @return
     */
    int countList();

}
