package cn.com.duiba.tuia.ssp.center.api.dto.finaceData;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
@Getter
@Setter
public class MediaDailyStatisticsDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 应用id */
    private Long appId;

    /** 应用名称 */
    private String appName;

    /** 应用所属平台 */
    private String platform;

    /** 入口曝光量 */
    private Long actExposeCount;

    /** 入口点击量 */
    private Long actClickCount;

    /** 入口点击UV */
    private Long actClickUv;

    /** 入口点击率 */
    private Long actClickRate;

    /** 活动请求UV */
    private Long actRequestUv;

    /** 活动请求PV */
    private Long actRequestCount;

    /** 活动参与次数 */
    private Long participateCount;

    /** 活动参与人数 */
    private Long participateUv;

    /** 参与率 */
    private Long actParticipateRate;

    /** 复参数 */
    private Long rptParticipateCount;

    /** 活动广告券请求 */
    private Long advertRequestCount;

    /** 每日发券量 */
    private Long launchCount;

    /** 请求成功率 */
    private Long requestSuccessRate;

    /** 发券成功率 */
    private Long launchSuccessRate;

    /** 广告曝光量 */
    private Long advertExposureCount;

    /** 广告点击量 */
    private Long advertClickCount;

    /** 广告点击率 */
    private Long advertClickRate;

    /** 广告点击单价(分) */
    private Long advertPerClickFee;

    /** 广告收入/广告点击量 */
    private Long arpu;

    /** 千次曝光产生的发券 */
    private Long spm;

    /** 千次曝光产生的广告消耗（分） */
    private Long ecpm;

    /** 活动UV单价（分） */
    private Long actPerRequestFee;

    /** 活动点击单价（分） */
    private Long actPerClickFee;

    /** 广告消耗（分） */
    private Long adConsume;

    /** 媒体预计分成（分） */
    private Long exConsumeTotal;

    /** 媒体应得分成（分） */
    private Long consumeTotal;

    /** 当天日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date curDate;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date gmtCreate;

    /** 修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date gmtModified;

    /** 流量引导页访问PV */
    private Long liuliangPv;

    /** 流量引导页访问UV */
    private Long liuliangUv;

    /** 广告位访问PV */
    private Long sdkPv;

    /** 广告位访问UV */
    private Long sdkUv;

    /** 广告位返回成功PV */
    private Long actSucResponseCount;

    /** 广告劵有效点击PV */
    private Long efClickCount;

    /** 高风险发券量 */
    private Long highriskLaunch;

    /** 媒体预计分成按分存储 */
    private Long mediaExDivide;

    /** 媒体应得分成按分存储 */
    private Long mediaDueDivide;

    /** 媒体账户id */
    private Long mediaId;

    /** 理论广告消耗（分） */
    private Long logicalConsume;

    /** 广告位曝光uv */
    private Long actExposeUv;

    /** 杭州每日广告消耗(分) */
    private Long hzAdConsume;

    /** 霍尔果斯每日广告消耗(分) */
    private Long hegsAdConsume;

    /** 杭州每日媒体预计分成(分） */
    private Long hzExConsumeTotal;

    /** 霍尔果斯每日媒体预计分成(分） */
    private Long hegsExConsumeTotal;

    /** 杭州每日消费(分) */
    private Long hzConsumeTotal;

    /** 霍尔果斯每日消费(分) */
    private Long hegsConsumeTotal;

    /** 杭州媒体预计分成按分存储 */
    private Long hzMediaExDivide;

    /** 霍尔果斯媒体预计分成按分存储 */
    private Long hegsMediaExDivide;

    /** 杭州媒体应得分成按分存储 */
    private Long hzMediaDueDivide;

    /** 霍尔果斯媒体应得分成按分存储 */
    private Long hegsMediaDueDivide;

    /** 付费券发券量      计费点击日志中，点击单价＞0的广告对应的发券量 */
    private Long payLaunchPv;

    /** 付费券曝光量      计费点击日志中，点击单价＞0的广告对应的曝光量 */
    private Long payExposurePv;

    /** 付费券计费点击量        计费点击日志中，点击单价＞0的广告对应的计费点击量 */
    private Long payEfClicks;

    /** ip访问量 */
    private Long ipRequestPv;

    /** 广告位有效访问pv */
    private Long slotEfRequestPv;

    /** 新客访问量 */
    private Long newRequestUv;

    /** 广告券请求数（互动） */
    private Long advertRequestCountHd;

    /** 广告券请求数（展示） */
    private Long advertRequestCountZs;

    /** 广告发券量（互动） */
    private Long launchCountHd;

    /** 广告发券量（展示） */
    private Long launchCountZs;

    /** 付费券发券量（互动） */
    private Long payLaunchHd;

    /** 付费券发券量（展示） */
    private Long payLaunchZs;

    /** 广告券曝光量（互动） */
    private Long advertExposureCountHd;

    /** 广告券曝光量（展示） */
    private Long advertExposureCountZs;

    /** 广告券点击量（互动） */
    private Long advertClickCountHd;

    /** 广告券点击量（展示） */
    private Long advertClickCountZs;

    /** 广告消耗（互动） */
    private Long adConsumeHd;

    /** 广告消耗（展示） */
    private Long adConsumeZs;

    /** 现金消耗(分) */
    private BigDecimal cashConsume;

    /** 杭州现金消耗(分) */
    private BigDecimal hzCashConsume;

    /** 霍尔果斯现金消耗(分) */
    private BigDecimal hegsCashConsume;

    /** 霍城兑捷每日广告消耗(分) */
    private Long hcdjAdConsume;

    /** 霍城兑捷每日媒体预计分成(分） */
    private Long hcdjExConsumeTotal;

    /** 霍城兑捷每日消费(分) */
    private Long hcdjConsumeTotal;

    /** 霍城兑捷媒体预计分成按分存储 */
    private Long hcdjMediaExDivide;

    /** 霍城兑捷媒体应得分成按分存储 */
    private Long hcdjMediaDueDivide;

    /** 霍城兑捷现金消耗(分) */
    private BigDecimal hcdjCashConsume;

    /** 客户类型 0-- 未选择  1--人工服务   2--自主化标识客户 */
    private Long clientType;

    /** 原有广告位访问UV */
    private Long sdkUvOriginal;

    /** 原有广告位有效访问pv */
    private Long slotEfRequestPvOriginal;

    /** 原有新客访问量 */
    private Long newRequestUvOriginal;

    /** 原有ip访问量 */
    private Long ipRequestPvOriginal;

    /** 原有广告消耗（分） */
    private Long adConsumeOriginal;

    /** 原有杭州每日广告消耗(分) */
    private Long hzAdConsumeOriginal;

    /** 原有霍尔果斯每日广告消耗(分) */
    private Long hegsAdConsumeOriginal;

    /** 原有霍城兑捷每日广告消耗(分) */
    private Long hcdjAdConsumeOriginal;

    /** 原有广告位访问PV */
    private Long sdkPvOriginal;

    /** 原有现金消耗(分) */
    private BigDecimal cashConsumeOriginal;

    /** 兑推每日广告消耗(分) */
    private Long duituiAdConsume;

    /** 兑推每日媒体预计分成(分） */
    private Long duituiExConsumeTotal;

    /** 兑推每日消费(分) */
    private Long duituiConsumeTotal;

    /** 兑推媒体预计分成按分存储 */
    private Long duituiMediaExDivide;

    /** 兑推媒体应得分成按分存储 */
    private Long duituiMediaDueDivide;

    /** 兑推现金消耗(分) */
    private BigDecimal duituiCashConsume;

    /** 原有兑推每日广告消耗(分) */
    private Long duituiAdConsumeOriginal;
}
