package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * 流转详情 DTO
 * @dateTime 2020-12-08 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class CirculationDetailDto implements Serializable {


    /**
     * 账户 Id
     */
    private String mediaId;

    /**
     * 账户名称
     */
    private String mediaName;

    /**
     * 发票金额 ( 分 )
     */
    private Long invoiceAmount;

    /**
     * 发票编号
     */
    private String invoiceNumber;

    /**
     * 请款日期 ( 格式: yyyy-MM-dd )
     */
    private String paymentDate;

    /**
     * 打款日期 ( 格式: yyyy-MM-dd )
     */
    private String payDate;

    /**
     * 收票日期 ( 格式: yyyy-MM-dd )
     */
    private String invoiceReceiveDate;

    /**
     * 流转状态
     * - { 0 : 媒介助理, 1 : 已提交财务 }
     */
    private Integer circulationStatus;

    /**
     * 备注
     */
    private String remark;

}
