package cn.com.duiba.tuia.ssp.center.api.dto.sdk;

import cn.com.duiba.tuia.ssp.center.api.tool.DateUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author K. L. Mao
 * @create 2020-01-03
 */
@Data
public class SdkCrashLogDetailDTO implements Serializable {

    private Long id;

    private String appName;

    private String imei;

    private String idfa;

    private String oaid;

    private String deviceId;

    private String sdkVersion;

    private String phoneBrand;

    private String phoneModel;

    // 系统版本
    private String osVersion;

    // 系统型号
    private String osType;

    // 包名
    private String packageName;

    /**
     * 处理状态：1-已处理 2-未处理 3-不可处理 9-其他
     * {@link cn.com.duiba.tuia.ssp.center.api.constant.enums.SdkCrashLogStatusEnum}
     */
    private Integer status;

    // 崩溃日志
    private String crashLogs;

    @JsonFormat(pattern = DateUtil.DEFAULT_FORMATTER, timezone = "GMT+8")
    private Date gmtCreate;

}
