package cn.com.duiba.tuia.ssp.center.api.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 媒体结算进度公司主体
 */
@AllArgsConstructor
@Getter
public enum MediaSettlementCompanyEnum {

    COMPANY_TYPE_HZ(TuiaCompanyType.HANG_ZHOU.getType(), "杭推"),

    COMPANY_TYPE_HEGS(TuiaCompanyType.HUO_ER_GUO_SI.getType(), "霍推"),

    COMPANY_TYPE_HCDJ(TuiaCompanyType.HCDJ.getType(), "兑捷"),

    COMPANY_TYPE_DT(TuiaCompanyType.DUI_TUI.getType(), "兑推")
    ;

    private Integer type;

    private String desc;

    public static String getDesc(Integer type) {
        for(MediaSettlementCompanyEnum settlementCompany : MediaSettlementCompanyEnum.values()) {
            if(Objects.equals(settlementCompany.getType(), type)) {
                return settlementCompany.getDesc();
            }
        }
        return null;
    }
}
