package cn.com.duiba.tuia.ssp.center.api.constant.enums;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2021/10/9
 * @Description
 * @Param
 * @return
 **/
@Getter
public enum AppOnlineOfflineEnum {
    /**
     * 未上线
     */
    INIT(1, "未上线"),
    /**
     * 上线
     */
    ONLINE(2, "上线"),
    /**
     * 休眠
     */
    DORMANT(3, "休眠"),
    /**
     * 下线
     */
    OFFLINE(4, "下线"),;


    private Integer code;

    private String desc;

    AppOnlineOfflineEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code){
        for (AppOnlineOfflineEnum appOnlineOfflineEnum : AppOnlineOfflineEnum.values()){
            if(appOnlineOfflineEnum.getCode().equals(code)){
                return appOnlineOfflineEnum.getDesc();
            }
        }
        return "";
    }
}
