/**
 * Project Name:media-biz File Name:Media.java Package Name:cn.com.duiba.tuia.media.domain Date:2016年9月26日上午11:32:48
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */
/**
 *
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveInfo;
import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveType;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkPutConfigDTO;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;
import java.util.List;

/**
 * 媒体信息.
 *
 * @author: guyan
 * @version:
 */
@SensitiveInfo(sensitiveFields = {"appName"})
public class MediaAppDto extends BaseDto {

    /** 开通状态:0-待审核. 待媒介审核*/
    public static final int     MEDIA_APP_CHECKING         = 0;
    /** 开通状态:1-审核通过. */
    public static final int     MEDIA_APP_CHECK_PASS       = 1;
    /** 开通状态:2-审核拒绝. */
    public static final int     MEDIA_APP_CHECK_FAIL       = 2;
    /** 开通状态:2-待审核. 待风控审核*/
    public static final int     MEDIA_RISK_CHECK        = 3;
    /** 系统平台:Android. */
    public static final String  MEDIA_APP_PLATFORM_ANDROID = "Android";
    /** 系统平台:iOS. */
    public static final String  MEDIA_APP_PLATFORM_IOS     = "iOS";
    /** 全部关闭状态 */
    public static final Integer ALL_SLOT_CLOSED_TRUE       = 0;
    /** 未全部关闭状态 */
    public static final Integer ALL_SLOT_CLOSED_FLASE      = 1;
    /** 未冻结 */
    public static final int     NO_FROZEN_STATUS           = 0;
    /** 已冻结 */
    public static final int     IS_FROZEN_STATUS           = 1;
    /** 序列ID. */
    private static final long serialVersionUID = -8738563858655851503L;


    /* 媒体白名单状态 否 */
    public static final Integer WHITELIST_STATUS_FALSE = 0;
    /* 媒体白名单状态 是 */
    public static final Integer WHITELIST_STATUS_TRUE = 1;

    /** 媒体用户ID. */
    private Long                mediaId;
    /** 媒体ID. */
    private Long                appId;
    /** 媒体标识. */
    private String              appKey;
    /** 媒体名称. */
    @SensitiveInfo(sensitiveType = SensitiveType.APP_NAME)
    private String              appName;
    /** app秘钥 */
    private String              appSecret;
    /** 行业. */
    private String              industry;
    /** 开通状态:0-待审核;1-审核通过;2-审核拒绝. */
    private Integer             checkStatus;
    /** 审核拒绝理由. */
    private String              refuseMsg;
    /** 验证状态:0-待验证;1-验证通过 */
    private Integer             verifyStatus;
    /** 系统平台:Android或iOS. */
    private String              platform;
    /** 程序主包名. */
    private String              appPackage;
    /** 媒体关键词. */
    private String              appKeyWords;
    /** 媒体简介. */
    private String              description;
    /** 下载地址. */
    private String              downloadUrl;

    /** 广告位全部关闭状态 */
    private Integer             allSlotClosed;

    /** 冻结状态 */
    private Integer             frozenStatus;

    /** 冻结原因 */
    private String              frozenReason;

    // 标签ID：一级-二级
    private String              tagId;

    // 标签名称：一级-二级
    private String              tagName;

    private String              tempIndustryTagId;

    // 标签名称：一级-二级
    private String              tempIndustryTagName;

    /** 账号类别: 0-未选 1-直客 2-代理 */
    private Integer             accountType;
    /** 流量标签ID **/
    private String              flowTagId;
    /** 流量标签名称 **/
    private String              flowTagName;
    /** 流量分级标签ID **/
    private String              gradeTagId;
    /** 流量分级标签名称 **/
    private String              gradeTagName;
    /** 网赚标签ID **/
    private String              emoTagId;
    /** 网赚标签名称 **/
    private String              emoTagName;

    /** 公众账号名称 */
    private String              officialAccountName;

    /** 公众号类别：0:订阅号，1：服务号 */
    private Integer             officialAccountType;

    /** 公众号主体，0:企业，1:个人 */
    private Integer             officialAccountSubject;

    /** 如果是子账号，媒体实际属于的账号ID */
    private Long                subMediaId;

    /** 0正常 1海外 */
    private Integer             overseas;
    /**媒体标签(广告那边的一级标签)*/
    private String              appTagNum;
    /**媒体是否支持下载类广告*/
    private Integer             downloadAdvert;

    /**媒体标签名称(来自广告一级标签)*/
    private String              appTagName;

    /* 媒体白名单状态 */
    private Integer             whitelistStatus;
    /* 客户类型 */
    private Integer             clientType;
    /* 是否媒体投放域名审核 */
    private Integer checkMediaLink;
    /** 订单展示开关 0:关闭,1:开启 */
    private Integer orderIconOnoff;

    /**
     * 风控对应的标签，风控支持多选，所以是list类型
     */
    private List<MediaTagDto> riskTags;
    /**
     * 交易方式对应的标签，交易方式支持多选，所以是list类型
     */
    private List<MediaTagDto> tradeTypeTags;
    /**
     * 流量载体对应的标签，流量载体支持多选，所以是list类型
     */
    private List<MediaTagDto> carrierFlowTags;

    /**
     * 流量渠道对应的标签，流量渠道支持多选，所以是list类型
     */
    private List<MediaTagDto> trafficChannelTags;

    private List<MediaTagDto> mediaUserPortraitTags;

    /**
     * 测试状态（0：初始状态(参加测试）；1：测试结束；2：测试完成
     **/
    private Integer tesStatus;

    /**
     * SDK 配置信息
     */
    private TuiaSdkPutConfigDTO tuiaSdkPutConfigDTO;

    /**
     * 行业标签ID（大类ID组别ID标签ID之间用-分割，如“5-21-249”）
     */
    private String industryTagId;

    /**
     * 行业标签名称
     */
    private String industryTagName;

    /**
     * 标签审核状态（0：未审核 1：已审核）
     */
    private Integer tagCheckStatus;

    private Integer testStatus;
    /**
     * 媒体上下线状态 1-未上线 2-上线 3-休眠 4-下线
     */
    private Integer appOnlineOfflineStatus;
    /**
     * 新媒体状态 1-未上线 2-新媒体 3-老媒体
     */
    private Integer newAppStatus;
    /**
     *媒体最新上线时间
     */
    private Date appOnlineTime;
    /**
     *媒体下线原因
     */
    private String appOfflineReason;

    private String costOneHundredTime;

    /**
     * 规则背景图
     */
    private String ruleBackground;


    public Integer getAppOnlineOfflineStatus() {
        return appOnlineOfflineStatus;
    }

    public void setAppOnlineOfflineStatus(Integer appOnlineOfflineStatus) {
        this.appOnlineOfflineStatus = appOnlineOfflineStatus;
    }

    public Integer getNewAppStatus() {
        return newAppStatus;
    }

    public void setNewAppStatus(Integer newAppStatus) {
        this.newAppStatus = newAppStatus;
    }


    public Date getAppOnlineTime() {
        return appOnlineTime;
    }

    public void setAppOnlineTime(Date appOnlineTime) {
        this.appOnlineTime = appOnlineTime;
    }

    public String getAppOfflineReason() {
        return appOfflineReason;
    }

    public void setAppOfflineReason(String appOfflineReason) {
        this.appOfflineReason = appOfflineReason;
    }

    public Integer getTestStatus() {
        return testStatus;
    }

    public void setTestStatus(Integer testStatus) {
        this.testStatus = testStatus;
    }

    public String getIndustryTagId() {
        return industryTagId;
    }

    public void setIndustryTagId(String industryTagId) {
        this.industryTagId = industryTagId;
    }

    public String getIndustryTagName() {
        return industryTagName;
    }

    public void setIndustryTagName(String industryTagName) {
        this.industryTagName = industryTagName;
    }

    public TuiaSdkPutConfigDTO getTuiaSdkPutConfigDTO() {
        return tuiaSdkPutConfigDTO;
    }

    public void setTuiaSdkPutConfigDTO(TuiaSdkPutConfigDTO tuiaSdkPutConfigDTO) {
        this.tuiaSdkPutConfigDTO = tuiaSdkPutConfigDTO;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getRefuseMsg() {
        return refuseMsg;
    }

    public void setRefuseMsg(String refuseMsg) {
        this.refuseMsg = refuseMsg;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppKeyWords() {
        return appKeyWords;
    }

    public void setAppKeyWords(String appKeyWords) {
        this.appKeyWords = appKeyWords;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public Integer getAllSlotClosed() {
        return allSlotClosed;
    }

    public void setAllSlotClosed(Integer allSlotClosed) {
        this.allSlotClosed = allSlotClosed;
    }

    public Integer getVerifyStatus() {
        return verifyStatus;
    }

    public void setVerifyStatus(Integer verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    public Integer getFrozenStatus() {
        return frozenStatus;
    }

    public void setFrozenStatus(Integer frozenStatus) {
        this.frozenStatus = frozenStatus;
    }

    public String getFrozenReason() {
        return frozenReason;
    }

    public void setFrozenReason(String frozenReason) {
        this.frozenReason = frozenReason;
    }

    public String getTagName() {
        return tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public String getFlowTagName() {
        return flowTagName;
    }

    public void setFlowTagName(String flowTagName) {
        this.flowTagName = flowTagName;
    }

    public String getGradeTagName() {
        return gradeTagName;
    }

    public void setGradeTagName(String gradeTagName) {
        this.gradeTagName = gradeTagName;
    }

    public String getEmoTagId() {
        return emoTagId;
    }

    public void setEmoTagId(String emoTagId) {
        this.emoTagId = emoTagId;
    }

    public String getEmoTagName() {
        return emoTagName;
    }

    public void setEmoTagName(String emoTagName) {
        this.emoTagName = emoTagName;
    }

    public String getOfficialAccountName() {
        return officialAccountName;
    }

    public void setOfficialAccountName(String officialAccountName) {
        this.officialAccountName = officialAccountName;
    }

    public Integer getOfficialAccountType() {
        return officialAccountType;
    }

    public void setOfficialAccountType(Integer officialAccountType) {
        this.officialAccountType = officialAccountType;
    }

    public Integer getOfficialAccountSubject() {
        return officialAccountSubject;
    }

    public void setOfficialAccountSubject(Integer officialAccountSubject) {
        this.officialAccountSubject = officialAccountSubject;
    }

    public Long getSubMediaId() {
        return subMediaId;
    }

    public void setSubMediaId(Long subMediaId) {
        this.subMediaId = subMediaId;
    }

    public Integer getOverseas() {
        return overseas;
    }

    public void setOverseas(Integer overseas) {
        this.overseas = overseas;
    }

    public String getAppTagNum() {
        return appTagNum;
    }

    public void setAppTagNum(String appTagNum) {
        this.appTagNum = appTagNum;
    }

    public Integer getDownloadAdvert() {
        return downloadAdvert;
    }

    public void setDownloadAdvert(Integer downloadAdvert) {
        this.downloadAdvert = downloadAdvert;
    }

    public String getAppTagName() {
        return appTagName;
    }

    public void setAppTagName(String appTagName) {
        this.appTagName = appTagName;
    }

    public Integer getWhitelistStatus() {
        return whitelistStatus;
    }

    public void setWhitelistStatus(Integer whitelistStatus) {
        this.whitelistStatus = whitelistStatus;
    }

    public List<MediaTagDto> getRiskTags() {
        return riskTags;
    }

    public void setRiskTags(List<MediaTagDto> riskTags) {
        this.riskTags = riskTags;
    }

    public List<MediaTagDto> getMediaUserPortraitTags() {
        return mediaUserPortraitTags;
    }

    public void setMediaUserPortraitTags(List<MediaTagDto> mediaUserPortraitTags) {
        this.mediaUserPortraitTags = mediaUserPortraitTags;
    }

    public Integer getTesStatus() {
        return tesStatus;
    }

    public void setTesStatus(Integer tesStatus) {
        this.tesStatus = tesStatus;
    }

    public Integer getCheckMediaLink() {
        return checkMediaLink;
    }

    public void setCheckMediaLink(final Integer checkMediaLink) {
        this.checkMediaLink = checkMediaLink;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public Integer getClientType() {
        return clientType;
    }

    public void setClientType(final Integer clientType) {
        this.clientType = clientType;
    }

    public Integer getOrderIconOnoff() {
        return orderIconOnoff;
    }

    public void setOrderIconOnoff(Integer orderIconOnoff) {
        this.orderIconOnoff = orderIconOnoff;
    }

    public Integer getTagCheckStatus() {
        return tagCheckStatus;
    }

    public void setTagCheckStatus(Integer tagCheckStatus) {
        this.tagCheckStatus = tagCheckStatus;
    }

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public String getFlowTagId() {
        return flowTagId;
    }

    public void setFlowTagId(String flowTagId) {
        this.flowTagId = flowTagId;
    }

    public String getGradeTagId() {
        return gradeTagId;
    }

    public void setGradeTagId(String gradeTagId) {
        this.gradeTagId = gradeTagId;
    }

    public List<MediaTagDto> getTradeTypeTags() {
        return tradeTypeTags;
    }

    public void setTradeTypeTags(List<MediaTagDto> tradeTypeTags) {
        this.tradeTypeTags = tradeTypeTags;
    }

    public List<MediaTagDto> getTrafficChannelTags() {
        return trafficChannelTags;
    }

    public void setTrafficChannelTags(List<MediaTagDto> trafficChannelTags) {
        this.trafficChannelTags = trafficChannelTags;
    }

    public List<MediaTagDto> getCarrierFlowTags() {
        return carrierFlowTags;
    }

    public void setCarrierFlowTags(List<MediaTagDto> carrierFlowTags) {
        this.carrierFlowTags = carrierFlowTags;
    }

    public String getCostOneHundredTime() {
        return costOneHundredTime;
    }

    public void setCostOneHundredTime(String costOneHundredTime) {
        this.costOneHundredTime = costOneHundredTime;
    }

    public String getRuleBackground() {
        return ruleBackground;
    }

    public void setRuleBackground(String ruleBackground) {
        this.ruleBackground = ruleBackground;
    }

    public String getTempIndustryTagId() {
        return tempIndustryTagId;
    }

    public void setTempIndustryTagId(String tempIndustryTagId) {
        this.tempIndustryTagId = tempIndustryTagId;
    }

    public String getTempIndustryTagName() {
        return tempIndustryTagName;
    }

    public void setTempIndustryTagName(String tempIndustryTagName) {
        this.tempIndustryTagName = tempIndustryTagName;
    }
}
