package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author liujianxue
 */
@Data
public class ReqResourceMaterialTagStatistics implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 2602776111753942620L;

    /** id类别：1-资源位 2-素材id**/
    private Integer extType;

    /** 资源位/素材IDS */
    @ApiModelProperty(value = "资源位/素材IDS", required = false)
    private List<Long>        extIds;

    /** 开始日期 */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String            startDate;

    /** 结束日期 */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String            endDate;

}
