package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 媒体结算进度
 */
@Data
public class SettledProgressDTO implements Serializable {

    private static final long serialVersionUID = -7438430843571782375L;

    /**
     * 	账号ID
     */
    private Long mediaId;

    /**
     * 账号名称
     */
    private String accountOpenman;

    /**
     * 	媒体性质（0:后付款 1:预付款）
     */
    private Integer prePayStatus;

    /**
     * 媒体性质变更记录
     */
    private List<SettledProgressPrePayStatusHistoryDTO> changeHistoryList;

    /**
     * 账户余额
     */
    private Long balance;

    /**
     * 预付款余额
     */
    private Long prePayBalance;

    /**
     * 霍城兑捷预付余额
     */
    private Long hcdjPrePayBalance;

    /**
     * 兑推预付余额
     */
    private Long duituiPrePayBalance;

    /**
     * 霍尔果斯预付余额
     */
    private Long hegsPrePayBalance;

    /**
     * 杭州预付余额
     */
    private Long hzPrePayBalance;

    /**
     * 欠票金额
     */
    private Long unbilledAmount;

    /**
     * 霍城兑捷欠票金额
     */
    private Long hcdjUnbilledAmount;

    /**
     * 兑推欠票金额
     */
    private Long duituiUnbilledAmount;

    /**
     * 霍尔果斯欠票金额
     */
    private Long hegsUnbilledAmount;

    /**
     * 杭州欠票金额
     */
    private Long hzUnbilledAmount;

    /**
     * 发票预警
     */
    private String invoicePrewarning;

    /**
     * 发票预警-霍城兑捷欠票金额
     */
    private Long invoiceHcdjUnbilledAmount;

    /**
     * 发票预警-兑推欠票金额
     */
    private Long invoiceDuituiUnbilledAmount;

    /**
     * 发票预警-霍尔果斯欠票金额
     */
    private Long invoiceHegsUnbilledAmount;

    /**
     * 发票预警-杭州欠票金额
     */
    private Long invoiceHzUnbilledAmount;

    /**
     * 结算单预警
     */
    private String settledPrewarning;

    /**
     * 结算单预警列表
     */
    private List settledPrewarningList;

    /**
     * 消耗含增值
     */
    private Long valueAddedConsume;

    /**
     * 预付款余额占比
     */
    private String ratio;

    /**
     * 预警等级（1:一级预警 2:二级预警 3:三级预警）
     */
    private Integer prewarningLevel;
}
