/**
 * Project Name:media-manager-biz File Name:BaseMaterialStatisticsRsp.java Package
 * Name:cn.com.duiba.tuia.media.manager.model.rsp Date:2017年3月16日下午3:23:25 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto.appDailyProfit;

import lombok.Builder;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 媒体每日利润基础
 */
@Data
public class BaseAppDailyProfitDto implements Serializable {
    /** 序列号 */
    private static final long serialVersionUID = -1981044282754704015L;


    /** 日期 */
    private String            curDate;


    /** 运营id */
    private Long              operatorId;

    /** 运营名称 */
    private String            operatorName;

    /** 广告消耗 */
    private Long              advertConsume;

    /** 广告现金消耗 */
    private Long              advertCashConsume;

    /** 分成 */
    private Long              consumeSharing;

    /** 现金分成 */
    private Long              cashSharing;

    /** 每日利润 */
    private Long              dailyProfit;
    
    /** 状态：0-未确定，1-确定 */
    private Integer           dataType;
    

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
