package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * 发票信息 DTO
 * @dateTime 2020-12-08 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class InvoiceInfoDto implements Serializable {


    /**
     * The id.
     */
    protected Long id;

    /**
     * 账户 Id
     */
    private String mediaId;

    /**
     * 账户名称
     */
    private String mediaName;

    /**
     * 上传时间 ( 格式: yyyy-MM-dd HH:mm:ss )
     */
    private String uploadDate;

    /**
     * 发票类型
     * - { 1 : 预付款单, 2 : 提现单, 3 : 预付款结算单 }
     */
    private Integer invoiceType;

    /**
     * 发票金额 ( 分 )
     */
    private Long invoiceAmount;

    /**
     * 发票编号
     */
    private String invoiceNumber;

    /**
     * 提现单号
     */
    private String withdrawalNumber;

    /**
     * 提现金额 ( 分 )
     */
    private Long withdrawalAmount;

    /**
     * 预付款单号
     */
    private String prepaymentsNumber;

    /**
     * 发票明细
     */
    private InvoiceDetailDto invoiceDetail;

    /**
     * 审核状态
     * - { 0 : 待审核, 1 : 审核通过, 2 : 审核拒绝 }
     */
    private Integer invoiceCheckStatus;

    /**
     * 审核·拒绝原因 / 通过说明
     */
    private String invoiceCheckReason;

    /**
     * 流转状态
     * - { 0 : 媒介助理, 1 : 已提交财务 }
     */
    private Integer circulationStatus;

    /**
     * 流转详情
     */
    private CirculationDetailDto circulationDetail;

}