package cn.com.duiba.tuia.ssp.center.api.remote.prePayInvoiceRecord.params;

import cn.com.duiba.tuia.ssp.center.api.dto.common.BasePage;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;
import java.io.Serializable;

/**
 * { 获取 } 发票追踪 Params
 * @dateTime 2020-12-08 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(fluent = false, chain = true, prefix = "")
public class GainInvoiceTrackingParams extends BasePage implements Serializable {


    /**
     * 追踪纬度
     */
    @ApiModelProperty(value = "追踪纬度: { 0 : 预付款打款维度, 1 : 预付款消耗维度 }", required = false)
    private Integer latitude = 0;

    /**
     * 账户名称
     */
    @ApiModelProperty(value = "账户名称", required = false)
    private String mediaName;

    /**
     * 账户 Id
     */
    @ApiModelProperty(value = "账户 Id", required = false)
    private String mediaId;

    /**
     * 搜索日期
     */
    @DateTimeFormat(pattern = "yyyy-MM")
    @ApiModelProperty(value = "搜索日期", required = false)
    private String searchDate;

    /**
     * 不分页标记
     */
    @JsonIgnore
    private Boolean notPagination;

}