package cn.com.duiba.tuia.ssp.center.api.remote.sdk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkPatchDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkRecordDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkVerifyRecordDTO;

import java.util.List;


@AdvancedFeignClient
public interface RemoteTuiaVerifyRecordService {

    TuiaSdkVerifyRecordDTO getById(Long id);

    List<TuiaSdkVerifyRecordDTO> findAll();

    PageResultDto<TuiaSdkVerifyRecordDTO> history(Long releaseId, Integer pageSize, Integer currentPage);

    TuiaSdkRecordDTO getLastRecordDto(Long pluginSetId);

    int getByPluginCode(Long pluginCode);

    List<TuiaSdkVerifyRecordDTO> findBySdkVersionCode(Long sdkVersionCode);

    /**
     * 根据sdk版本号获取补丁列表
     * open-web 使用
     * @param sdkVersionName
     * @return
     */
    List<TuiaSdkPatchDTO> findBySdkVersionName(String sdkVersionName);

    /**
     * 灰度补丁人数加1
     * open-web 使用
     * @param recordId
     * @return
     */
    Boolean incrementGrayLimit(Long recordId);
}
