package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 结算单
 */
@Data
public class SettledDTO implements Serializable {

    private static final long serialVersionUID = 3816943000306255716L;

    private Long id;

    /**
     * 添加日期
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date gmtCreate;

    /**
     * 操作人
     */
    private String managerName;

    /**
     * 	账号ID
     */
    private Long mediaId;

    /**
     * 公司主体（0：杭推 1：霍推 2：兑捷）
     * @see cn.com.duiba.tuia.ssp.center.api.constant.TuiaCompanyType
     */
    private Integer companyType;

    /**
     * 结算金额
     */
    private Long cashAmount;

    /**
     * 多个结算月份
     */
    private String dates;

    /**
     * 审核状态（0:驳回 1:待财务审核 2:审核通过）
     */
    private Integer checkStatus;

    /**
     * 操作人ID
     */
    private Long managerId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 结算月份
     */
    private String settledDate;

    /**
     * 拒绝原因
     */
    private String refuseReason;

    /**
     * 结算单号
     */
    @ApiModelProperty("结算单号")
    private String settlementId;

    private Long cashOrderId;
}
