package cn.com.duiba.tuia.ssp.center.api.dto.appDailyProfit;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * 媒体每日利润基础
 */
@Data
@ApiModel
public class BaseAppDailyProfitDto implements Serializable {
    /** 序列号 */
    private static final long serialVersionUID = -1981044282754704015L;

    @ApiModelProperty(value = "运营id", required = false)
    private Long              Id;

    @ApiModelProperty(value = "日期", required = false)
    private String            curDate;

    @ApiModelProperty(value = "运营id", required = false)
    private Long              operatorId;

    @ApiModelProperty(value = "运营名称", required = false)
    private String            operatorName;

    @ApiModelProperty(value = "广告消耗", required = false)
    private Long              advertConsume;

    @ApiModelProperty(value = "广告现金消耗", required = false)
    private Long              advertCashConsume;

    @ApiModelProperty(value = "分成", required = false)
    private Long              consumeSharing;

    @ApiModelProperty(value = "现金分成", required = false)
    private Long              cashSharing;

    @ApiModelProperty(value = "每日利润", required = false)
    private Long              dailyProfit;
    
    @ApiModelProperty(value = "状态：0-未确定，1-确定", required = false)
    private Integer           dataType;
    

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
