package cn.com.duiba.tuia.ssp.center.api.dto.appDailyProfit;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * 联盟媒体每日利润
 */
@Data
@Builder
@ApiModel
public class UnionAppDailyProfitDto extends BaseAppDailyProfitDto {
    /** 序列号 */
    private static final long serialVersionUID = -3323315628443058575L;

    @ApiModelProperty(value = "媒体id", required = false)
    private Long              appId;

    @ApiModelProperty(value = "媒体名称", required = false)
    private String            appName;

    @ApiModelProperty(value = "媒体消耗", required = false)
    private Long              appConsume;

    @ApiModelProperty(value = "uv消耗", required = false)
    private Long              uvConsume;



    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
