package cn.com.duiba.tuia.ssp.center.api.remote.activityTestPlan;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.activityTestPlan.ActivityAndSlotTestReq;
import cn.com.duiba.tuia.ssp.center.api.dto.activityTestPlan.ActivityTestPlanReq;
import cn.com.duiba.tuia.ssp.center.api.dto.activityTestPlan.ActivityTestPlanDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteActivityTestPlanService {

    /**
     * 分页
     *
     * @param param
     * @return
     */
    PageResultDto<ActivityTestPlanDto> pageList(ActivityTestPlanReq param);

    /**
     * 测试计划ID查询
     *
     * @param planIds
     * @return
     */
    List<ActivityTestPlanDto> queryListByIds(List<Long> planIds);

    /**
     * 保存活动测试计划
     *
     * @return
     */
    Boolean saveActivityTestPlan(ActivityAndSlotTestReq param);

    /**
     * 关闭活动测试计划状态
     *
     * @param id
     * @return
     */
    Boolean closeActivityTestPlan(Long id);

    /**
     * 删除活动测试计划
     *
     * @param id
     * @return
     */
    Boolean delActivityTestPlan(Long id);

    /**
     * 查询活动测试计划详情
     *
     * @param planId
     * @return
     */
    ActivityTestPlanDto getActivityTestPlanById(Long planId);
}
