package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: AccountChangeDto <br/>
 * date: 2016年12月6日 下午5:31:42 <br/>
 *
 * @author ZFZ
 * @version
 * @since JDK 1.6
 */
public class AccountChangeDto extends BaseDto {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID                   = 1872562288213960505L;

    /** 操作类型：0-增加余额 */
    public static final int   CHANGE_TYPE_ADD                    = 0;

    /** 操作类型：1-减少余额 */
    public static final int   CHANGE_TYPE_SUB                    = 1;

    /** 扣款范围大于或等于0 */
    public static final int   AMOUNT_SCALE_GREATER_THAN_OR_EQUAL = 0;

    /** 扣款范围小于0 */
    public static final int   AMOUNT_SCALE_LESS_THAN             = 1;

    /** 金额初始值 */
    public static final long  AMOUNT_INIT_VAL                    = 0;
    
    /**提现说明*/
    public static final String CASH_REMARK="提现";
    
    
    /** 杭州当前余额 */
    public static final int    HZ_BALANCE                         = 0;

    /** 霍尔果斯当前余额 */
    public static final int    HEGS_BALANCE                       = 1;

    /** 霍尔果斯当前余额 */
    public static final int    BALANCE                            = 2;

    /** 霍城兑捷当前余额*/
    public static final int   HCDJ_BALANCE                        = 3;

    /** 兑推当前余额*/
    public static final int   DT_BALANCE                          = 4;

    /** 媒体用户ID. */
    private Long              mediaId;

    /** 媒体账户结算表id. */
    private Long              settlementId;

    /** 结算月份. */
    private Date              curDate;

    /** 操作类型：0-增加余额，1-减少余额. */
    private Integer           changeType;

    /** 加款/扣款 金额 (分). */
    private Long              amount;

    /** 当前余额 (分). */
    private Long              balance;

    /** 杭州当前余额 (分). */
    private Long              hzBalance;

    /** 霍尔果斯当前余额 (分). */
    private Long              hegsBalance;

    /** 霍城兑捷当前余额(分）.*/
    private Long              hcdjBalance;

    /** 兑推当前余额(分）.*/
    private Long              duituiBalance;

    /** 备注. */
    private String            remark;
    
    /**杭州金额*/
    private Long             hzAmount;
    
    /**霍尔果斯金额*/
    private Long             hegsAmount;

    /** 霍城兑捷金额 */
    private Long             hcdjAmount;

    /** 兑推金额 */
    private Long             duituiAmount;

    /** 操作类型：0-增加余额，1-减少余额. */
    private int          hzChangeType;

    /** 操作类型：0-增加余额，1-减少余额. */
    private int          hegsChangeType;

    /** 霍城兑捷 操作类型：0-增加余额，1-减少余额.  */
    private byte              hcdjChangeType;

    /** 兑推 操作类型：0-增加余额，1-减少余额.  */
    private int          duituiChangeType;

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * settlementId.
     *
     * @return the settlementId
     * @since JDK 1.6
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * settlementId.
     *
     * @param settlementId the settlementId to set
     * @since JDK 1.6
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.6
     */
    public Date getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.6
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    /**
     * changeType.
     *
     * @return the changeType
     * @since JDK 1.6
     */
    public Integer getChangeType() {
        return changeType;
    }

    /**
     * changeType.
     *
     * @param changeType the changeType to set
     * @since JDK 1.6
     */
    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    /**
     * amount.
     *
     * @return the amount
     * @since JDK 1.6
     */
    public Long getAmount() {
        return amount;
    }

    /**
     * amount.
     *
     * @param amount the amount to set
     * @since JDK 1.6
     */
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    /**
     * balance.
     *
     * @return the balance
     * @since JDK 1.6
     */
    public Long getBalance() {
        return balance;
    }

    /**
     * balance.
     *
     * @param balance the balance to set
     * @since JDK 1.6
     */
    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public Long getHzBalance() {
        return hzBalance;
    }

    public void setHzBalance(Long hzBalance) {
        this.hzBalance = hzBalance;
    }

    public Long getHegsBalance() {
        return hegsBalance;
    }

    public void setHegsBalance(Long hegsBalance) {
        this.hegsBalance = hegsBalance;
    }

    /**
     * remark.
     *
     * @return the remark
     * @since JDK 1.6
     */
    public String getRemark() {
        return remark;
    }

    /**
     * remark.
     *
     * @param remark the remark to set
     * @since JDK 1.6
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    
    public Long getHzAmount() {
        return hzAmount;
    }

    
    public void setHzAmount(Long hzAmount) {
        this.hzAmount = hzAmount;
    }

    
    public Long getHegsAmount() {
        return hegsAmount;
    }
    
    public void setHegsAmount(Long hegsAmount) {
        this.hegsAmount = hegsAmount;
    }

    public Long getHcdjBalance() {
        return hcdjBalance;
    }

    public void setHcdjBalance(Long hcdjBalance) {
        this.hcdjBalance = hcdjBalance;
    }

    public Long getHcdjAmount() {
        return hcdjAmount;
    }

    public void setHcdjAmount(Long hcdjAmount) {
        this.hcdjAmount = hcdjAmount;
    }

    public int getHzChangeType() {
        return hzChangeType;
    }

    public void setHzChangeType(int hzChangeType) {
        this.hzChangeType = hzChangeType;
    }

    public int getHegsChangeType() {
        return hegsChangeType;
    }

    public void setHegsChangeType(int hegsChangeType) {
        this.hegsChangeType = hegsChangeType;
    }

    public byte getHcdjChangeType() {
        return hcdjChangeType;
    }

    public void setHcdjChangeType(byte hcdjChangeType) {
        this.hcdjChangeType = hcdjChangeType;
    }

    public Long getDuituiBalance() {
        return duituiBalance;
    }

    public void setDuituiBalance(Long duituiBalance) {
        this.duituiBalance = duituiBalance;
    }

    public Long getDuituiAmount() {
        return duituiAmount;
    }

    public void setDuituiAmount(Long duituiAmount) {
        this.duituiAmount = duituiAmount;
    }

    public int getDuituiChangeType() {
        return duituiChangeType;
    }

    public void setDuituiChangeType(int duituiChangeType) {
        this.duituiChangeType = duituiChangeType;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
