package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

@ApiModel
public class ReqNoticeDto extends ReqPageQuery {

	private static final long serialVersionUID = -5439911255537604104L;
	private List<Long> idNotInList;

	@ApiModelProperty(value = "通知标题")
	private String title;

	@ApiModelProperty(value = "通知id列表")
	private List<Long> noticeIds;

	@ApiModelProperty(value = "媒体id")
	private Long mediaId;

	@ApiModelProperty(value = "媒体创建时间")
	private Date createTime;

	/** The start date. */
    @ApiModelProperty(value = "开始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String startDate;

    /** The end date. */
    @ApiModelProperty(value = "结束日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endDate;

	private String mediaIdAddComma;

	@ApiModelProperty(value = "通知类型（1：系统通知，2：推啊news通知)")
	private Integer noticeType;

	@ApiModelProperty(value = "查询条数")
	private Integer limitNum;

	@ApiModelProperty(value = "推啊news类型（0：推啊头条，1：推啊玩法，2：推啊季刊）")
	private Integer newsType;

	/**
	 * 消息类型:1-媒体线通知;2-火眼数据通知;3-广告线通知;4-实验平台通知;5-分控通知;6-其他
	 */
	private Integer messageType;
	/**
	 * 平台:1-媒体后台;2-媒体管理后台
	 */
	private Integer platform;

	public Integer getMessageType() {
		return messageType;
	}

	public void setMessageType(Integer messageType) {
		this.messageType = messageType;
	}

	public Integer getPlatform() {
		return platform;
	}

	public void setPlatform(Integer platform) {
		this.platform = platform;
	}

	public List<Long> getIdNotInList() {
		return idNotInList;
	}

	public void setIdNotInList(List<Long> idNotInList) {
		this.idNotInList = idNotInList;
	}

	public Integer getNoticeType() {
		return noticeType;
	}

	public void setNoticeType(Integer noticeType) {
		this.noticeType = noticeType;
	}
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public List<Long> getNoticeIds() {
		return noticeIds;
	}

	public void setNoticeIds(List<Long> noticeIds) {
		this.noticeIds = noticeIds;
	}

	public Long getMediaId() {
		return mediaId;
	}

	public void setMediaId(Long mediaId) {
		this.mediaId = mediaId;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getStartDate() {
		return startDate;
	}

	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}

	public String getEndDate() {
		return endDate;
	}

	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}

	public String getMediaIdAddComma() {
		return mediaIdAddComma;
	}

	public void setMediaIdAddComma(String mediaIdAddComma) {
		this.mediaIdAddComma = mediaIdAddComma;
	}

	public Integer getLimitNum() {
		return limitNum;
	}

	public void setLimitNum(Integer limitNum) {
		this.limitNum = limitNum;
	}

	public Integer getNewsType() {
		return newsType;
	}

	public void setNewsType(Integer newsType) {
		this.newsType = newsType;
	}

}
