package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 媒体结算进度
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ReqSettledProgress extends BaseQueryDto {

    private static final long serialVersionUID = 352295598609074627L;

    /**
     * 账号ID
     */
    private Long mediaId;

    /**
     * 账号名称
     */
    private String accountOpenman;

    /**
     * 	媒体性质（0:后付款 1:预付款）
     */
    private Integer prePayStatus;

    /**
     * 预警等级（1:一级预警 2:二级预警 3:三级预警）
     */
    private Integer prewarningLevel;

    /**
     * 账号ID列表
     */
    private List<Long> mediaIds;

    /**
     * 开始日期
     */
    private Date startDate;

    /**
     * 结束日期
     */
    private Date endDate;
}
