package cn.com.duiba.tuia.ssp.center.api.remote.appDailyProfit;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.tuia.ssp.center.api.dto.appDailyProfit.*;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAppDailyProfitService {

	/**
	 * 联盟数据列表
	 * @param req
	 * @return
	 */
	PageResultDto<UnionAppDailyProfitDto> listUnion(UnionAppDailyProfitReq req);

	/**
	 * 单个联盟数据查询
	 * @param id
	 * @return
	 */
	UnionAppDailyProfitDto selectUnionAppDailyProfit(Long id);

	/**
	 * 更新联盟分成数据
	 * @param req
	 * @return
	 */
	Boolean updateUnionCashSharing(UnionAppDailyProfitDto req);

	/**
	 * 确认联盟分成数据
	 * @param req
	 * @return
	 */
	Boolean confirmUnionDailyData(UnionAppDailyProfitReq req);

	/**
	 * 删除要被剔除的操作员（即不是最新的运营列表里的运营）
	 * @param operatorIds
	 * @return
	 */
	Boolean deleteNotInOperator(List<Long> operatorIds);

	/**
	 * 新增运营列表
	 * @param operatorList
	 * @return
	 */
	Boolean batchInsertOperator(List<UnionAppDailyProfitOperatorDto> operatorList);

	/**
	 * 已添加的运营列表
	 * @return
	 */
	List<UnionAppDailyProfitOperatorDto> queryAddUnionOperatorList();

	/**
	 * 运营最新的分成数据
	 * @param dto
	 */
	Boolean insertUpdateOperatorCashSharing(UnionAppDailyProfitCashSharingDto dto);

	/**
	 * 程序化利润数据列表
	 * @param req
	 * @return
	 */
	PageResultDto<ProgrammaticAppDailyProfitDTo> listProgrammatic(ProgrammaticAppDailyProfitReq req);

	/**
	 * 新增程序化平台利润数据
	 * @param dto
	 * @return
	 */
	Boolean addPlatformCashSharing(ProgrammaticAppDailyProfitDTo dto);

	/**
	 * 单个程序化数据查询
	 * @param id
	 * @return
	 */
	ProgrammaticAppDailyProfitDTo selectProgrammaticAppDailyProfit(Long id);

	/**
	 * 更新程序化分成数据
	 * @param req
	 * @return
	 */
	Boolean updateProgrammaticCashSharing(ProgrammaticAppDailyProfitDTo req);

	/**
	 * 确认程序化利润分成数据
	 * @param req
	 * @return
	 */
	Boolean confirmProgrammaticDailyData(ProgrammaticAppDailyProfitReq req);

	/**
	 * 添加平台
	 * @param dto
	 * @return
	 */
	Boolean addProgrammaticPlatform(ProgrammaticAppDailyProfitPlatformDto dto);

	/**
	 * 已添加平台列表
	 * @return
	 */
	List<ProgrammaticAppDailyProfitPlatformDto> programmaticPlatformList(Long platformId);

	/**
	 * 更新运营绑定的平台、最新分成
	 * @param dto
	 * @return
	 */
	Boolean addUpdateProgrammaticBindingPlatform(ProgrammaticAppDailyProfitBindingPlatformDto dto);

	/**
	 * 运营绑定的平台、最新分成集合
	 * @param dto
	 * @return
	 */
	List<ProgrammaticAppDailyProfitBindingPlatformDto> selectProgrammaticBindingPlatform(ProgrammaticAppDailyProfitBindingPlatformDto dto);

}
