package cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * { 已接入 } 应用信息
 * @dateTime 2020-07-13 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class AlreadyApplication implements Serializable {


    /**
     * 媒体 Id
     */
    private String mediaId;

    /**
     * 应用 Id
     */
    private String appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 应用 · 创建时间
     */
    private String creationTime;

    /**
     * 媒介 Id
     */
    private String mediumId;

    /**
     * 媒介名称
     */
    private String mediumName;

    /**
     * 行业 · 应用 Id
     */
    private String industryAppId;

    /**
     * 行业 · 应用名称
     */
    private String industryAppName;

    /**
     * 行业 · 领域 Id
     */
    private String industryCateId;

    /**
     * 行业 · 领域名称
     */
    private String industryCateName;

    /**
     * 消耗状态
     * -- { 0 : 无消耗 , 1 : 有消耗 , 默认 : 0 }.
     */
    private Integer consumeStatus;

    /**
     * 扩展
     */
    private AlreadyApplicationExtend extend;






}