package cn.com.duiba.tuia.ssp.center.api.remote.mediaTest.dto;

import cn.com.duiba.tuia.activity.center.api.common.OrderBy;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Optional;

/**
 * 分页信息 :: 分页条件
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@Accessors(fluent = false, chain = true, prefix = "")
public class GainPaging extends GainCondition implements Serializable {

    private static final long serialVersionUID = -3652906932396268830L;

    /**
     * 页码
     */
    @JsonProperty(value = "currentPage")
    private Integer page;

    /**
     * 条数
     */
    @JsonProperty(value = "pageSize")
    private Integer size;

    /**
     * 下标
     * -- 开始下标
     */
    private Integer subscript;

    /**
     * 排序
     */
    private OrderBy sort;

    /**
     * 验证赋值
     */
    public void validate() {
        int page = Optional.ofNullable(this.getPage()).orElse(1);
        int size = Optional.ofNullable(this.getSize()).orElse(20);
        this.setSubscript((page - 1) * size).setSize(size).setPage(page);
    }

}
