package cn.com.duiba.tuia.ssp.center.api.dto.appDailyProfit;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.List;

@Data
@ApiModel
public class ProgrammaticAppDailyProfitReq extends BaseQueryDto {

    private static final long serialVersionUID = 3831443832799643264L;

    @ApiModelProperty(value = "开始时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String startDate;

    @ApiModelProperty(value = "endDate", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endDate;

    @ApiModelProperty(value = "运营id", required = false)
    private List<Long> operatorIds;

    @ApiModelProperty(value = " 运营名称", required = false)
    private String            operatorName;

    @ApiModelProperty(value = " 平台名称", required = false)
    private String            platformName;

    @ApiModelProperty(value = " 状态：0-未确定，1-确定", required = false)
    private Integer           dataType;

    @ApiModelProperty(value = " 排序字段名", required = false)
    private String           orderByName;

    @ApiModelProperty(value = "排序类型：0-倒序，1-正序", required = false)
    private Integer           orderType;

}
