package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaCompanyMsgDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 媒体公司信息及财务信息
 */
@AdvancedFeignClient
public interface RemoteMediaCompanyMsgService {

    /**
     * 媒体用户修改公司信息
     *
     * @param dto
     * @return
     */
    DubboResult<Boolean> updateCompanyMsg(MediaCompanyMsgDto dto);

    /**
     * 新增用户公司信息
     *
     * @param dto
     * @return
     */
    DubboResult<Boolean> insertCompanyMsg(MediaCompanyMsgDto dto);

    /**
     * 通过媒体账户ID查询财务信息下公司信息
     *
     * @param mediaId
     * @return
     */
    DubboResult<MediaCompanyMsgDto> selectCompanyMsgById(Long mediaId);

    /**
     * 通过媒体ID集合，批量查询财务信息
     * @param mediaIds
     * @return
     */
    DubboResult<List<MediaCompanyMsgDto>> selectCompanyListMsgByIds(List<Long> mediaIds);

    void certificationDingNotice(Long mediaId);
}
