package cn.com.duiba.tuia.ssp.center.api.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 素材格式类型
 */
@Getter
@AllArgsConstructor
public enum SlotMaterialFormatTypeEnum {

    /**广告位使用普通素材*/
    BIND_NORMAL(0),

    /**广告位使用svga素材*/

    BIND_SVGA(1),
    ;

    private Integer type;

    public static Set<Integer> getAllTypes() {
        return Arrays.stream(SlotMaterialFormatTypeEnum.values()).map(SlotMaterialFormatTypeEnum::getType).collect(Collectors.toSet());
    }
}
