package cn.com.duiba.tuia.ssp.center.api.constant.enums;

import lombok.Getter;

/**
 * @Author yuquanfeng
 * @Date 2021/10/9
 * @Description
 * @Param
 * @return
 **/
@Getter
public enum AppDailyProfitOrderByNameEnum {
    ADVERT_CONSUME(0, "advert_consume"),//广告消耗
    ADVERT_CASH_CONSUME(1, "advert_cash_consume"),//广告现金消耗
    APP_CASH_CONSUME(2, "app_cash_consume"),//媒体现金消耗
    CONSUME_REBATE(3, "consume_rebate"),//后台返点
    CONSUME_SHARING(4, "consume_sharing"),//分成
    CASH_SHARING(5, "cash_sharing"),//现金分成
    DAILY_PROFIT(6, "daily_profit"),//每日利润
    DATA_TYPE(7, "data_type")//0:未确认，1:已确认
    ;

    private Integer code;

    private String desc;

    AppDailyProfitOrderByNameEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code){
        for(AppDailyProfitOrderByNameEnum appDailyProfitOrderByNameEnum : AppDailyProfitOrderByNameEnum.values()){
            if(appDailyProfitOrderByNameEnum.getCode().equals(code)){
                return appDailyProfitOrderByNameEnum.getDesc();
            }
        }
        return "advert_consume";
    }

}
