package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
@Data
public class AdvertTagMapDto implements Serializable {
	
	private static final long serialVersionUID = -5431806212809784481L;

    /**
     * ID
     **/
    @ApiModelProperty(value = "ID", required = true)
	private Long id;

    /**
     * 广告端标签编号
     **/
    @ApiModelProperty(value = "广告端标签编号", required = false)
    private String tagNum;

    /**
     * 标签名称
     **/
    @ApiModelProperty(value = "标签名称", required = true)
    private String title;

    /**
     * 父级ID
     **/
    @ApiModelProperty(value = "父级ID", required = false)
    private Long pid;

    /**
     * 标签级别,目前为1和2
     **/
    @ApiModelProperty(value = "标签级别,目前为1和2", required = true)
    private Integer tagLevel;

    /**
     * 子标签集合
     **/
    @ApiModelProperty(value = "子标签集合", required = false)
    private List<AdvertTagMapDto> child;

    /**
     * 是否删除
     **/
    @ApiModelProperty(value = "是否删除", required = false)
    private Integer isDeleted;

}