package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 编辑手投预估数据
 *
 * @author zhangzhenghe
 * @since 2020-04-10 5:29 PM
 */
@Data
public class ManualSlotDailyDataDTO implements Serializable {

    private static final long serialVersionUID = 7980233674984902952L;

    /**
     * 操作类型(0:确认 1:修改)
     */
    @NotNull(message = "操作类型不能为空")
    @Range(min = 0, max = 1, message = "操作类型参数错误")
    private Integer operationType;

    /**
     * 预估数据
     */
    @NotEmpty(message = "数据列表不能为空")
    private List<RspManualSlotDailyData> dataList;
}
