package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@ApiModel
public class MediaFormAutoFillDTO implements Serializable {

    /**
     * 媒体Id
     */
    @ApiModelProperty(value = "媒体Id", required = true)
    @NotNull
    private Long appId;

    /**
     * 自动填单状态
     */
    @ApiModelProperty(value = "自动填单状态", required = true)
    @NotNull
    private Byte autoStatus;

    /**
     * 请求自动填单信息的URL
     */
    @ApiModelProperty(value = "请求自动填单信息的URL", required = false)
    private String url;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Byte getAutoStatus() {
        return autoStatus;
    }

    public void setAutoStatus(Byte autoStatus) {
        this.autoStatus = autoStatus;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String toString() {
        return "MediaFormAutoFillDTO{" +
                "appId=" + appId +
                ", autoStatus=" + autoStatus +
                ", url='" + url + '\'' +
                '}';
    }
}
