package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 预付款发票信息
 */
@Api("预付款发票信息")
@Data
public class MediaPrePayInvoiceDTO implements Serializable {

    private static final long serialVersionUID = -4749477041756136496L;

    @ApiModelProperty(value = "主键", required = true)
    private Long id;

    @ApiModelProperty(value = "主体类型（0：杭州推啊网络有限公司 1：霍尔果斯网络有限公司 2：霍城兑捷网络有限公司）", required = true)
    private Integer companyType;

    @ApiModelProperty(value = "上传日期（格式：yyyy-MM-dd HH:mm:ss）", required = true)
    private String gmtCreate;

    @ApiModelProperty(value = "发票金额", required = true)
    private Long invoiceAmount;

    @ApiModelProperty(value = "发票状态（0：待审核 1：审核通过 2：审核拒绝）", required = true)
    private Integer invoiceCheckStatus;

    @ApiModelProperty(value = "发票审核原因")
    private String checkReason;
}
