package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * 活动广告位定向请求参数
 *
 * @author zhangzhenghe
 * @since 2019-11-27 11:12
 */
public class ReqActivityDirectSlotDTO implements Serializable {

    private static final long serialVersionUID = 5183896798112494252L;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * 活动来源 0：兑吧活动  1：推啊活动  2：流量引导页
     */
    private Integer actSource;

    /**
     * 定向开关 0：关 1：开
     */
    private Integer directStatus;

    /**
     * 广告位ID列表
     */
    private List<Long> slotIds;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Integer getActSource() {
        return actSource;
    }

    public void setActSource(Integer actSource) {
        this.actSource = actSource;
    }

    public Integer getDirectStatus() {
        return directStatus;
    }

    public void setDirectStatus(Integer directStatus) {
        this.directStatus = directStatus;
    }

    public List<Long> getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
