/**
 * Project Name:media-biz File Name:Media.java Package Name:cn.com.duiba.tuia.media.domain Date:2016年9月26日上午11:32:48
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */
/**
 * 
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkPutConfigDTO;
import lombok.Data;

import java.util.List;

/**
 * 媒体信息.
 *
 * @author: guyan
 * @version:
 */
@Data
public class SlotMediaAppDto extends BaseDto {

    private Long                slotId;

    private String              slotName;

    /** 媒体用户ID. */
    private Long                mediaId;
    /** 媒体ID. */
    private Long                appId;
    /** 媒体标识. */
    private String              appKey;
    /** 媒体名称. */
    private String              appName;
    /** app秘钥 */
    private String              appSecret;
    /** 行业. */
    private String              industry;
    /** 开通状态:0-待审核;1-审核通过;2-审核拒绝. */
    private Integer             checkStatus;
    /** 审核拒绝理由. */
    private String              refuseMsg;
    /** 验证状态:0-待验证;1-验证通过 */
    private Integer             verifyStatus;
    /** 系统平台:Android或iOS. */
    private String              platform;
    /** 程序主包名. */
    private String              appPackage;
    /** 媒体关键词. */
    private String              appKeyWords;
    /** 媒体简介. */
    private String              description;
    /** 下载地址. */
    private String              downloadUrl;

    /** 广告位全部关闭状态 */
    private Integer             allSlotClosed;

    /** 冻结状态 */
    private Integer             frozenStatus;

    /** 冻结原因 */
    private String              frozenReason;

    // 标签名称：一级-二级
    private String              tagName;

    /** 账号类别: 0-未选 1-直客 2-代理 */
    private Integer             accountType;
    /** 流量标签名称 **/
    private String              flowTagName;
    /** 流量分级标签名称 **/
    private String              gradeTagName;

    /** 公众账号名称 */
    private String              officialAccountName;

    /** 公众号类别：0:订阅号，1：服务号 */
    private Integer             officialAccountType;

    /** 公众号主体，0:企业，1:个人 */
    private Integer             officialAccountSubject;

    /** 如果是子账号，媒体实际属于的账号ID */
    private Long                subMediaId;

    /** 0正常 1海外 */
    private Integer             overseas;
    /**媒体标签(广告那边的一级标签)*/
    private String              appTagNum;
    /**媒体是否支持下载类广告*/
    private Integer             downloadAdvert;

    /**媒体标签名称(来自广告一级标签)*/
    private String              appTagName;

    /* 媒体白名单状态 */
    private Integer             whitelistStatus;
    /* 客户类型 */
    private Integer             clientType;
    /* 是否媒体投放域名审核 */
    private Integer checkMediaLink;
    /** 订单展示开关 0:关闭,1:开启 */
    private Integer orderIconOnoff;

    /**
     * 风控对应的标签，风控支持多选，所以是list类型
     */
    private List<MediaTagDto> riskTags;

    private List<MediaTagDto> mediaUserPortraitTags;

    /**
     * 测试状态（0：初始状态(参加测试）；1：测试结束；2：测试完成
     **/
    private Integer tesStatus;

    /**
     * SDK 配置信息
     */
    private TuiaSdkPutConfigDTO tuiaSdkPutConfigDTO;

    /**
     * 行业标签ID（大类ID组别ID标签ID之间用-分割，如“5-21-249”）
     */
    private String industryTagId;

    /**
     * 行业标签名称
     */
    private String industryTagName;

}
