/**
 * Project Name:media-api File Name:ReqDataStatisticsByPageDto.java Package Name:cn.com.duiba.tuia.media.api.dto.req
 * Date:2016年10月11日下午3:09:44 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto.abnormal;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Author zhangliwei
 * @Description  广告位上传数据审核列表查询参数
 * @Date 17:15 2020-03-06
 * @Param
 * @return
 **/
@ApiModel
@Data
public class ReqUploadAuditDataByPageDto extends BaseQueryDto {

    /** 序列号 */
    private static final long  serialVersionUID = 8466057043049882890L;


    @ApiModelProperty(value = "广告位ID")
    private Long    slotId;

    @ApiModelProperty(value = "广告位名称")
    private String  slotName;

    @ApiModelProperty(value = "媒体ID")
    private Long    appId;

    @ApiModelProperty(value = "媒体名称")
    private String  appName;

    @ApiModelProperty(value = "审核状态 0-待审核 1-审核通过 2-审核拒绝 3-待上传数据")
    private Integer    auditStatus;


}
