/**
 * Project Name:media-biz<br/>
 * File Name:AdsenseDto.java<br/>
 * Package Name:cn.com.duiba.tuia.media.domain<br/>
 * Date:2016年9月26日下午5:05:11<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto.abnormal;

import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveInfo;
import cn.com.duiba.tuia.ssp.center.api.annotation.SensitiveType;
import cn.com.duiba.tuia.ssp.center.api.dto.BaseDto;
import cn.com.duiba.tuia.ssp.center.api.dto.abnormal.UploadDataAndFeeDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @Author zhangliwei
 * @Description  管理端返回前端列表数据
 * @Date 22:59 2020-03-04
 * @Param
 * @return
 **/
@Data
@ApiModel
@SensitiveInfo(sensitiveFields = {"appName","slotName"})
public class RspManualUploadDataAuditDto extends BaseDto {

    /**审核表ID*/
    @ApiModelProperty(value = "审核表ID", required = false)
    private Long id;

    /**媒体ID*/
    @ApiModelProperty(value = "媒体ID", required = false)
    private Long appId;

    /**广告位ID*/
    @ApiModelProperty(value = "广告位ID", required = false)
    private Long slotId;

    /**app名称*/
    @ApiModelProperty(value = "媒体名称", required = false)
    @SensitiveInfo(sensitiveType = SensitiveType.APP_NAME)
    private String appName;

    /**广告位名称*/
    @ApiModelProperty(value = "广告位名称", required = false)
    @SensitiveInfo(sensitiveType = SensitiveType.APP_NAME)
    private String slotName;

    /**媒体运营名称*/
    @ApiModelProperty(value = "媒体运营名称", required = false)
    private String managerName;

    @ApiModelProperty(value = "媒体最新提交时间", required = false)
    private Date lastSubmitDate;

    /**广告位曝光PV*/
    @ApiModelProperty(value = "待审记录数", required = false)
    private Integer count;

}
