package cn.com.duiba.tuia.ssp.center.api.dto.advertiser;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

@Data
public class AdvertiserThreePartyAuditStatusDTO implements Serializable {

    private static final long serialVersionUID = -4263919435683533017L;

    private Long id;

    /**
     * 广告主id
     */
    private Long advertiserId;

    /**
     * 第三方广告主id
     */
    private Long threePartyAdvertiserId;

    /**
     * adx类型
     */
    private Integer adxType;

    /**
     * 审核状态
     */
    @NotNull(message = "审核状态不能为空")
    private Integer auditStatus;

    /**
     * 审核理由
     */
    private String remark;

    /**
     * 审核日期
     */
    private Date auditOn;

    /**
     * 创建日期
     */
    private Date gmtCreate;

    /**
     * 修改日期
     */
    private Date gmtModified;

}
