package cn.com.duiba.tuia.ssp.center.api.dto.mediaapp;

import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class StatisticsCvrRsp implements Serializable {
    private static final long serialVersionUID = -7926624500488741498L;

    private List<Long> buzIds;

    /**
     * 开始日期
     */
    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private String            startDate;

    /**
     * 结束日期
     */
    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private String            endDate;

    public List<Long> getBuzIds() {
        return buzIds;
    }

    public void setBuzIds(List<Long> buzIds) {
        this.buzIds = buzIds;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
}
