package cn.com.duiba.tuia.ssp.center.api.dto.prePayInvoiceRecord;

import cn.com.duiba.tuia.ssp.center.api.dto.common.BasePage;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.List;

@Data
public class PrePayInvoiceRecordReq extends BasePage {

    private static final long serialVersionUID = 6026401073033417521L;

    @ApiModelProperty(value = "主键ID")
    private Long id;

    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String startDate;

    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String endDate;

    @ApiModelProperty(value = "媒体用户ID", required = false)
    private Long mediaId;

    @ApiModelProperty(value = "开票方式：0-消耗 1-打款", required = false)
    private Integer invoiceWay;

    @ApiModelProperty(value = "开票主体：0-杭州 1-霍尔果斯", required = false)
    private Integer invoiceBody;

    @ApiModelProperty(value = "公司主体：0-杭州 1-霍尔果斯", required = false)
    private Integer companyType;

    @ApiModelProperty(value = "发票状态：0-媒介助理 1-已提交财务", required = false)
    private Integer invoiceStatus;

    @ApiModelProperty(value = "截止日期之前")
    private String beforeDate;

    @ApiModelProperty(value = "发票审核状态：0-待审核 1-审核通过 2-审核拒绝")
    private Integer invoiceCheckStatus;

    @ApiModelProperty(value = "发票号列表")
    private List<String> invoiceNoList;

    @ApiModelProperty(value = "发票类型（1：预付款单 2：提现单 3：预付款结算单）")
    private Integer invoiceType;

    @JsonIgnore
    private List<Long> mediaIds;

    @ApiModelProperty(value = "提现单号")
    private Long cashOrderId;
}
