package cn.com.duiba.tuia.ssp.center.api.dto.unicom;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * SDK对接单次访问信息（暂时联通需求插入）
 * @author miaohongshuai
*/
@Data
@Builder
public class SdkAccessInfoDTO implements Serializable {

    private static final long serialVersionUID = -6414979578744875913L;
    private String deviceId;

    private String tuiaImei;

    private String tuiaIdfa;

    private String tuiaOaid;

    /**
     * 推啊唯一标识，对应SDK获取的fox_n
     */
    private String uniqueId;

    private Long appId;

    private Long slotId;

    private String tuiaUa;

    private String areaCode;


    private String tuiaIp;

    /**
     * DMP碰撞结果，0：否，1：是
     */
    private Integer ysDmp;
    /**
     * 实际运营商查询结果，0：否，1：是
     */
    private Integer ysReal;
    /**
     * 运营商类型，0- 未知、1- 中国移动、2- 中国电信、3- 中国联通、99-其他运营商'
     */
    private Integer ysType;
    /**
     * 查询三方后真正的运营商类型，0- 未知、1- 中国移动、2- 中国电信、3- 中国联通、99-其他运营商'
     */
    private Integer ysRealType;
    /**
     * 库存
     */
    private Integer storeNum;
    /**
     * 详细信息
     */
    private String detailInfo;
    /**
     * 登录类型，1-推啊登录弹层，2-联通一键，3-免登录，4-推啊一键
     */
    private Integer loginType;
    /**
     * 登录来源，1-联通4G，2-联通SDKwifi，3-联通支付宝无DMP
     */
    private Integer loginFrom;
    /**
     * 失败原因，取自错误码描述，不超过64字符
     */
    private String failRemark;
}
