package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountDto;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountRecordDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.AdminSSODto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqUpdateMediaAccount;
import cn.com.duiba.tuia.ssp.center.api.dto.common.IdAndTypeDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAccountService {

    DubboResult<Integer> insert(AccountDto accountDto);

    DubboResult<AccountDto> selectByPhone(String phone);

    DubboResult<Integer> updateEmail(String email, Long mediaId);

    DubboResult<Integer> updatePasswdByEmail(String password, String email);

    DubboResult<Integer> updateEmailStatus(Integer status, Long mediaId);

    DubboResult<Integer> updateRoleType(Integer roleType, Long mediaId);

    DubboResult<Integer> updateAccount(String companyName, String linkman, Long mediaId, String linkmanAddr);

    DubboResult<Integer> updatePhoneNum(String phoneNum, Long mediaId);

    DubboResult<Integer> selectFirstEnterStatus(Long mediaId);

    DubboResult<Integer> updateFirstEnterStatus(Long mediaId);

    /**
     * updateIsOffline:(修改媒体账号设置). <br/>
     *
     * @param param
     * @return
     * @author guyan
     * @since JDK 1.6
     */
    DubboResult<Integer> updateIsOffline(ReqUpdateMediaAccount param);

    /**
     * selectMediaIdAndType:(查询媒体账户ID和媒体账户类型). <br/>
     *
     * @param accountType
     * @return
     * @author guyan
     * @since JDK 1.6
     */
    DubboResult<List<IdAndTypeDto>> selectMediaIdAndType(Integer accountType);

    /**
     * selectMediaIdAndTypeByIds:(查询媒体账户ID和媒体账户类型通过媒体ids). <br/>
     *
     * @param mediaIds
     * @return
     * @author guyan
     * @since JDK 1.6
     */
    @FeignHystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "10000")
    DubboResult<List<IdAndTypeDto>> selectMediaIdAndTypeByIds(List<Long> mediaIds);

    Long selectFirstRewardStatus(Long mediaId);


    int updateFirstRewardStatus(Long mediaId);

    /**
     * 更新媒体条款状态
     *
     * @param mediaId
     * @return
     */
    int updateTermsStatus(Long mediaId);

    /**
     * 更新媒体账号合同状态
     * @param mediaId
     * @param contractStatus
     * @return
     */
    int updateContractStatus(Long mediaId,Byte contractStatus);

    List<AccountDto> selectByMediaIds(List<Long> mediaIds);

    int updateHasGuidance(Long mediaId);

    AccountDto selectByMediaId(Long mediaId);

    /**
     * @return
     * @Description 根据代理商 ID 查询其下的代理商子账号
     * @Author yupengwu
     * @Date 2019-03-14 16:06
     * @Param
     **/
    List<AccountDto> selectChildsByParentMediaId(Long mediaId);

    /**
     * 更新媒体是否已经引导获取广告位链路的标识
     * @param mediaId
     * @return
     */
    Boolean updateHasGuidSlotLink(Long mediaId);

    /**
     * 判断手机号是否是媒介的手机号
     * @param phone
     * @return
     */
    Boolean checkPhoneIsMedium(String phone);

    AdminSSODto getAdminDtoByPhone(String phone);

    /**
     * 预付款状态变更记录
     */
    List<AccountRecordDTO> listAccountRecordByMediaIds(List<Long> mediaIds);

    /**
     * 临时用，查询出全部子账号（当前数据量1000条不到）
     */
    List<AccountDto> findAllSubAccount();
}
