/**
 * Copyright (c) 2018, Ysoul. All rights reserved.
 */
package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.activity.center.api.constant.DomainMappingSceneEnum;
import cn.com.duiba.tuia.ssp.center.api.constant.DomainSceneType;
import cn.com.duiba.tuia.ssp.center.api.dto.DomainCheckManagerDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.params.DomainCheckManagerQuery;

import java.util.List;

/**
 * 类描述: 域名管理查询
 *
 * @author <a href="651850874@qq.com">Ysoul</a>
 * @version 1.0 2018-01-24
 * @since 1.0
 */
@AdvancedFeignClient
public interface RemoteDomainCheckManagerService {

    /**
     * 查询
     *
     * @param id
     * @return
     */
    DomainCheckManagerDto selectById(Long id);

    /**
     * 查询
     *
     * @param domainName
     * @return
     */
    DomainCheckManagerDto selectByDomainName(String domainName);

    DomainCheckManagerDto selectByParam(DomainCheckManagerDto domainCheckManagerDto);

    /**
     * 批量查询
     *
     * @param domainNameList
     * @return
     */
    List<DomainCheckManagerDto> selectByDomainNameList(List<String> domainNameList);

    /**
     * 查询有效的游戏域名
     * @return
     */
    List<DomainCheckManagerDto> selectValidGameDomain();

    /**
     * 分页查询
     *
     * @param query
     * @return
     */
    PageResultDto<DomainCheckManagerDto> selectByParams(DomainCheckManagerQuery query);

    /**
     * 无分页查询
     * @param query
     * @return
     */
    List<DomainCheckManagerDto> selectByParamsNoPage(DomainCheckManagerQuery query);

    /**
     * 获取所有
     * @return
     */
    List<DomainCheckManagerDto> selectAll();

    /**
     * 插入
     *
     * @param domainCheckManagerDto
     * @return
     */
    int insert(DomainCheckManagerDto domainCheckManagerDto);

    /**
     * 批量插入
     *
     * @param list
     * @return
     */
    int insertBatch(List<DomainCheckManagerDto> list);

    /**
     * 更新
     *
     * @param domainCheckManagerDto
     * @return
     */
    int update(DomainCheckManagerDto domainCheckManagerDto);

    /**
     * 域名策略预警
     *
     * @param dto
     * @param firstBlood 第一次被微信屏蔽
     */
    void warning(DomainCheckManagerDto dto, int firstBlood);

    void reSetDomainTagRelation();


    /**
     * 查询域名·根据场景
     * @param scene 查询·场景
     * @return 处理结果
     */
    List<DomainCheckManagerDto> selectDomainByScene(String scene);

    /**
     * 微信扫码·域名预警
     * @param domainId 域名 Id
     * @param firstBlood 第一次被微信扫码屏蔽
     */
    void wechatScanWarning(long domainId, int firstBlood);

    /**
     * 域名切换+屏蔽报警+策略预警，支付宝、微信扫描、微信点击，统一处理方法
     * @param dto
     * @param firstBlood
     * @param sceneType
     * @param mappingSceneEnum
     */
    void domainSwitchAndWarning(DomainCheckManagerDto dto, int firstBlood, DomainSceneType sceneType, DomainMappingSceneEnum mappingSceneEnum);

    String selectAppFlowLevelDomainBySlotId(Long slotId);

}
