package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;

import java.util.List;

/**
 * 素材优选库
 *
 * @author zhangzhenghe
 * @since 2020-02-04 11:07 AM
 */
@AdvancedFeignClient
public interface RemoteMaterialPreferredService {

    /**
     * 新增优选素材
     */
    Result<Boolean> saveBatchPreferredMaterial(ReqMaterialPreferred reqMaterialPreferred);

    /**
     * 删除优选素材
     */
    Result<Boolean> removePreferredMaterial(Long materialId);

    /**
     * 查询优选素材列表
     */
    Result<List<RspMaterialPreferred>> listPreferredMaterial(ReqMaterialPreferred reqMaterialPreferred);

    /**
     * 查询优选素材列表数目
     */
    Result<Integer> countPreferredMaterial(ReqMaterialPreferred reqMaterialPreferred);

    /**
     * 添加收藏
     */
    Result<Boolean> saveFavoriteMaterial(ReqMaterialFavorite reqMaterialFavorite);

    /**
     * 删除收藏
     */
    Result<Boolean> removeFavoriteMaterial(ReqMaterialFavorite reqMaterialFavorite);

    /**
     * 查询收藏列表
     */
    Result<List<RspMaterialFavorite>> listFavoriteMaterial(ReqMaterialFavorite reqMaterialFavorite);

    /**
     * 查询收藏列表数目
     */
    Result<Integer> countFavoriteMaterial(ReqMaterialFavorite reqMaterialFavorite);

    /**
     * 搜索匹配广告位
     */
    Result<List<RspMaterialMatchSlot>> listMatchSlot(ReqMaterialMatchSlot reqMaterialMatchSlot);

    /**
     * 搜索匹配广告位数目
     */
    Result<Integer> countMatchSlot(ReqMaterialMatchSlot reqMaterialMatchSlot);
}
